/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;

public class TileEntityFramedChestRenderer
extends TileEntityBiblioRenderer {
    private IBakedModel smallLid;
    private IBakedModel largeLidLeft;
    private IBakedModel largeLidRight;
    private IBakedModel latch;
    private String customTextureString = "none";
    private BiblioWoodBlock.EnumWoodType wood = BiblioWoodBlock.EnumWoodType.OAK;
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/framedchest.obj");
    private IBlockState state;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String returnValue = location.toString();
            if (returnValue.contentEquals("minecraft:blocks/planks_oak")) {
                returnValue = TileEntityFramedChestRenderer.this.customTextureString;
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(returnValue);
        }
    };

    @Override
    public void render(BiblioTileEntity tile, double x, double y, double z, float tick) {
        if (tile instanceof TileEntityFramedChest) {
            TileEntityFramedChest chest = (TileEntityFramedChest)tile;
            if (this.state == null) {
                this.state = chest.func_145831_w().func_180495_p(chest.func_174877_v());
            }
            this.initModels(chest);
            this.func_147499_a(TextureMap.field_110575_b);
            float lid = chest.getPrevLidAngle() + (chest.getLidAngle() - chest.getPrevLidAngle()) * tick;
            lid = 1.0f - lid;
            lid = 1.0f - lid * lid * lid;
            lid *= 90.0f;
            if (chest.getIsDouble()) {
                if (chest.getIsLeft()) {
                    this.renderPart(this.largeLidLeft, 1.0, 0.625, 0.05, lid);
                    this.renderPart(this.latch, 1.5, 0.625, 0.05, lid);
                } else {
                    this.renderPart(this.largeLidRight, 1.0, 0.625, 0.05, lid);
                }
            } else {
                this.renderPart(this.smallLid, 1.0, 0.625, 0.05, lid);
                this.renderPart(this.latch, 1.0, 0.625, 0.05, lid);
            }
            this.renderSlotItem(chest.getLabelStack(), 0.5, 0.23, 0.93, 0.5f);
        }
    }

    private void initModels(TileEntityFramedChest chest) {
        this.wood = BiblioWoodBlock.EnumWoodType.getEnum(chest.func_145832_p());
        switch (this.wood) {
            case OAK: {
                this.customTextureString = "minecraft:blocks/planks_oak";
                break;
            }
            case SPRUCE: {
                this.customTextureString = "minecraft:blocks/planks_spruce";
                break;
            }
            case BIRCH: {
                this.customTextureString = "minecraft:blocks/planks_birch";
                break;
            }
            case JUNGLE: {
                this.customTextureString = "minecraft:blocks/planks_jungle";
                break;
            }
            case ACACIA: {
                this.customTextureString = "minecraft:blocks/planks_acacia";
                break;
            }
            case DARKOAK: {
                this.customTextureString = "minecraft:blocks/planks_big_oak";
                break;
            }
            case FRAME: {
                if (chest.getCustomTextureString().contains("none") || chest.getCustomTextureString().contains("minecraft:white")) {
                    this.customTextureString = "bibliocraft:blocks/frame";
                    break;
                }
                this.customTextureString = chest.getCustomTextureString();
                break;
            }
            default: {
                this.customTextureString = "minecraft:blocks/planks_oak";
            }
        }
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)this.modelLocation);
        }
        catch (Exception e) {
            model = ModelLoaderRegistry.getMissingModel();
        }
        model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        ArrayList<String> smallPart = new ArrayList<String>();
        smallPart.add("small_lid");
        ArrayList<String> largeLeftPart = new ArrayList<String>();
        largeLeftPart.add("large_lid_left");
        ArrayList<String> largeRightPart = new ArrayList<String>();
        largeRightPart.add("large_lid_right");
        ArrayList<String> latchPart = new ArrayList<String>();
        latchPart.add("latch");
        OBJModel.OBJState smallState = new OBJModel.OBJState(smallPart, true);
        OBJModel.OBJState largeLeftState = new OBJModel.OBJState(largeLeftPart, true);
        OBJModel.OBJState largeRightState = new OBJModel.OBJState(largeRightPart, true);
        OBJModel.OBJState latchState = new OBJModel.OBJState(latchPart, true);
        this.smallLid = model.bake((IModelState)smallState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        this.largeLidLeft = model.bake((IModelState)largeLeftState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        this.largeLidRight = model.bake((IModelState)largeRightState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        this.latch = model.bake((IModelState)latchState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
    }

    private void renderPart(IBakedModel model, double x, double y, double z, float rotation) {
        switch (this.getAngle()) {
            case SOUTH: {
                double tx = x;
                x = -z;
                z = tx;
                break;
            }
            case WEST: {
                x *= -1.0;
                z *= -1.0;
                break;
            }
            case NORTH: {
                double tx = x;
                x = z;
                z = -tx;
                break;
            }
            case EAST: {
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(this.globalX + (double)this.xshift + x), (double)(this.globalY + y), (double)(this.globalZ + (double)this.zshift + z));
        GlStateManager.func_179114_b((float)((float)this.degreeAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

