/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityTypewriter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;

public class TileEntityTypeWriterRenderer
extends TileEntityBiblioRenderer {
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/typewriter.obj");
    private IBakedModel[] slideModels = new IBakedModel[16];
    private IBakedModel[] paperModels = new IBakedModel[16];
    private EnumColor color = EnumColor.WHITE;
    private String paperTexture = "bibliocraft:models/typewriter_paper_blank";
    private boolean init = false;
    private IBlockState state;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String returnValue = location.toString();
            if (returnValue.contains("bibliocraft:models/typewriter0")) {
                switch (TileEntityTypeWriterRenderer.this.color) {
                    case WHITE: {
                        returnValue = "bibliocraft:models/typewriter0";
                        break;
                    }
                    case LIGHT_GRAY: {
                        returnValue = "bibliocraft:models/typewriter1";
                        break;
                    }
                    case GRAY: {
                        returnValue = "bibliocraft:models/typewriter2";
                        break;
                    }
                    case BLACK: {
                        returnValue = "bibliocraft:models/typewriter3";
                        break;
                    }
                    case RED: {
                        returnValue = "bibliocraft:models/typewriter4";
                        break;
                    }
                    case ORANGE: {
                        returnValue = "bibliocraft:models/typewriter5";
                        break;
                    }
                    case YELLOW: {
                        returnValue = "bibliocraft:models/typewriter6";
                        break;
                    }
                    case LIME: {
                        returnValue = "bibliocraft:models/typewriter7";
                        break;
                    }
                    case GREEN: {
                        returnValue = "bibliocraft:models/typewriter8";
                        break;
                    }
                    case CYAN: {
                        returnValue = "bibliocraft:models/typewriter9";
                        break;
                    }
                    case LIGHT_BLUE: {
                        returnValue = "bibliocraft:models/typewriter10";
                        break;
                    }
                    case BLUE: {
                        returnValue = "bibliocraft:models/typewriter11";
                        break;
                    }
                    case PURPLE: {
                        returnValue = "bibliocraft:models/typewriter12";
                        break;
                    }
                    case MAGENTA: {
                        returnValue = "bibliocraft:models/typewriter13";
                        break;
                    }
                    case PINK: {
                        returnValue = "bibliocraft:models/typewriter14";
                        break;
                    }
                    case BROWN: {
                        returnValue = "bibliocraft:models/typewriter15";
                    }
                }
            }
            if (returnValue.contains("bibliocraft:models/typewriter_paper_")) {
                returnValue = TileEntityTypeWriterRenderer.this.paperTexture;
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(returnValue);
        }
    };

    @Override
    public void render(BiblioTileEntity tile, double x, double y, double z, float tick) {
        if (!this.init) {
            this.initModels();
            this.init = true;
        }
        if (tile instanceof TileEntityTypewriter) {
            TileEntityTypewriter typewriter = (TileEntityTypewriter)tile;
            if (this.state == null) {
                this.state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            }
            this.func_147499_a(TextureMap.field_110575_b);
            double adjust = 0.14;
            int writeCount = typewriter.getBookWriteCount();
            adjust = writeCount == 0 ? 0.0 : 0.14 - 0.02 * (double)writeCount;
            if (typewriter.getHasPaper()) {
                this.renderPart(this.paperModels[typewriter.getBookWriteCount()], adjust);
            }
            this.renderPart(this.slideModels[tile.func_145832_p()], adjust);
        }
    }

    private void renderPart(IBakedModel model, double x) {
        double y = 0.0;
        double z = 0.09;
        float rotation = 0.0f;
        x += 1.0;
        switch (this.getAngle()) {
            case SOUTH: {
                double tx = x;
                x = -z;
                z = tx;
                break;
            }
            case WEST: {
                x *= -1.0;
                z *= -1.0;
                break;
            }
            case NORTH: {
                double tx = x;
                x = z;
                z = -tx;
                break;
            }
            case EAST: {
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(this.globalX + (double)this.xshift + x), (double)(this.globalY + y), (double)(this.globalZ + (double)this.zshift + z));
        GlStateManager.func_179114_b((float)((float)this.degreeAngle + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void initModels() {
        IModel model;
        int i;
        for (i = 0; i < EnumColor.values().length; ++i) {
            model = null;
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)this.modelLocation);
            }
            catch (Exception e) {
                model = ModelLoaderRegistry.getMissingModel();
            }
            model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            ArrayList<String> slide = new ArrayList<String>();
            slide.add("slide");
            OBJModel.OBJState slideState = new OBJModel.OBJState(slide, true);
            this.color = EnumColor.getColorEnumFromID(i);
            this.slideModels[i] = model.bake((IModelState)slideState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        }
        for (i = 0; i < this.paperModels.length; ++i) {
            model = null;
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)this.modelLocation);
            }
            catch (Exception e) {
                model = ModelLoaderRegistry.getMissingModel();
            }
            model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            ArrayList<String> paper = new ArrayList<String>();
            String paperModel = "paperLine1";
            if (i >= 0) {
                paperModel = "paperLine1";
            }
            if (i >= 3) {
                paperModel = "paperLine2";
            }
            if (i >= 5) {
                paperModel = "paperLine3";
            }
            if (i >= 8) {
                paperModel = "paperLine4";
            }
            if (i >= 10) {
                paperModel = "paperLine5";
            }
            if (i >= 12) {
                paperModel = "paperLine6";
            }
            if (i >= 14) {
                paperModel = "paperLine7";
            }
            paper.add(paperModel);
            OBJModel.OBJState paperState = new OBJModel.OBJState(paper, true);
            this.paperTexture = i == 0 ? "bibliocraft:models/typewriter_paper_blank" : "bibliocraft:models/typewriter_paper_" + i;
            this.paperModels[i] = model.bake((IModelState)paperState, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
        }
    }
}

