/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.horses;

import com.animania.Animania;
import com.animania.addons.farm.common.entity.horses.EntityFoalBase;
import com.animania.addons.farm.common.entity.horses.EntityMareBase;
import com.animania.addons.farm.common.entity.horses.EntityStallionBase;
import com.animania.addons.farm.common.entity.horses.HorseDraft;
import com.animania.api.interfaces.AnimaniaType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.world.World;

public enum HorseType implements AnimaniaType
{
    DRAFT(HorseDraft.EntityStallionDraftHorse.class, HorseDraft.EntityMareDraftHorse.class, HorseDraft.EntityFoalDraftHorse.class);

    private Class stallion;
    private Class mare;
    private Class foal;

    private HorseType(Class stallion, Class mare, Class foal) {
        this.stallion = stallion;
        this.mare = mare;
        this.foal = foal;
    }

    public EntityStallionBase getMale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.stallion.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityStallionBase stallion = null;
        try {
            stallion = (EntityStallionBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return stallion;
    }

    public EntityMareBase getFemale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.mare.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityMareBase mare = null;
        try {
            mare = (EntityMareBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return mare;
    }

    public EntityFoalBase getChild(World world) {
        Constructor constructor = null;
        try {
            constructor = this.foal.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityFoalBase foal = null;
        try {
            foal = (EntityFoalBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return foal;
    }

    public static HorseType breed(HorseType male, HorseType female) {
        return Animania.RANDOM.nextBoolean() ? male : female;
    }

    @Override
    public String getTypeName() {
        return "animania:horse";
    }
}

