/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.pullables;

import com.animania.Animania;
import com.animania.addons.farm.FarmAddon;
import com.animania.addons.farm.common.entity.pigs.EntityAnimaniaPig;
import com.animania.addons.farm.common.entity.pullables.AnimatedEntityBase;
import com.animania.addons.farm.common.entity.pullables.EntityTiller;
import com.animania.addons.farm.common.entity.pullables.EntityWagon;
import com.animania.addons.farm.common.handler.FarmAddonItemHandler;
import com.animania.addons.farm.common.handler.FarmAddonSoundHandler;
import com.animania.addons.farm.common.inventory.CartChest;
import com.animania.common.helper.AnimaniaHelper;
import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCart
extends AnimatedEntityBase
implements IInventoryChangedListener {
    protected static AnimationHandler animHandler = CraftStudioApi.getNewAnimationHandler(EntityCart.class);
    public boolean pulled;
    public Entity puller;
    public CartChest cartChest;
    public float deltaRotation;
    private int lerpSteps;
    private double cartPitch;
    private double lerpY;
    private double lerpZ;
    public double cartYaw;
    private double lerpXRot;
    protected static final DataParameter<Integer> PULLER_TYPE = EntityDataManager.func_187226_a(EntityCart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityCart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityCart.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> HAS_CHEST = EntityDataManager.func_187226_a(EntityCart.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int GUI_ID = 0 + FarmAddon.guiHandler.getGuiIdOffset();

    public EntityCart(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.2f);
        this.field_70130_N = 2.0f;
        this.field_70131_O = 1.2f;
        this.field_70138_W = 1.2f;
        this.puller = null;
        this.pulled = false;
        this.initCartChest();
    }

    public EntityCart(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public AnimationHandler getAnimationHandler() {
        return animHandler;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public double func_70042_X() {
        return 0.62;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        int i;
        ItemStack stack = player.func_184586_b(hand);
        boolean isPulling = false;
        List horses = AnimaniaHelper.getEntitiesInRange(EntityHorse.class, (double)3.0, (World)this.field_70170_p, (Entity)player);
        List pigs = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPig.class, (double)3.0, (World)this.field_70170_p, (Entity)player);
        List carts = AnimaniaHelper.getEntitiesInRangeGeneric(EntityCart.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
        List wagons = AnimaniaHelper.getEntitiesInRangeGeneric(EntityWagon.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
        List tillers = AnimaniaHelper.getEntitiesInRangeGeneric(EntityTiller.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
        if (!carts.isEmpty()) {
            for (i = 0; i < carts.size(); ++i) {
                EntityCart tempCart = (EntityCart)((Object)carts.get(i));
                if (!tempCart.pulled || tempCart.puller != player.func_184187_bx()) continue;
                isPulling = true;
            }
        }
        if (!wagons.isEmpty()) {
            for (i = 0; i < wagons.size(); ++i) {
                EntityWagon tempWagon = (EntityWagon)((Object)wagons.get(i));
                if (!tempWagon.pulled || tempWagon.puller != player.func_184187_bx()) continue;
                isPulling = true;
            }
        }
        if (!tillers.isEmpty()) {
            for (i = 0; i < tillers.size(); ++i) {
                EntityTiller tempTiller = (EntityTiller)((Object)tillers.get(i));
                if (!tempTiller.pulled || tempTiller.puller != player.func_184187_bx()) continue;
                isPulling = true;
            }
        }
        EntityHorse horse = null;
        EntityAnimaniaPig pig = null;
        if (!horses.isEmpty()) {
            horse = (EntityHorse)horses.get(0);
        }
        if (!pigs.isEmpty()) {
            pig = (EntityAnimaniaPig)pigs.get(0);
        }
        if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K && this.getHasChest()) {
                this.cartChest.func_110133_a(this.func_70005_c_());
                player.openGui((Object)Animania.instance, GUI_ID, player.field_70170_p, this.func_145782_y(), 0, 0);
                this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187657_V, SoundCategory.PLAYERS, 0.7f, 1.0f);
            } else if (!this.getHasChest() && stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150486_ae) && player.func_184187_bx() != this) {
                player.func_184220_m((Entity)this);
                this.field_184245_j = 20;
                if (this.puller == player) {
                    this.puller = null;
                    this.pulled = false;
                    this.setPullerType(0);
                    this.stopCart();
                }
            }
            return true;
        }
        if (!player.func_70093_af()) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !this.getHasChest() && !this.func_184207_aI()) {
                this.setHasChest(true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187654_U, SoundCategory.PLAYERS, 0.7f, 1.0f);
                }
                return true;
            }
            if (player.func_184218_aH() && this.puller != player && this.puller != player.func_184187_bx() && player.func_184187_bx() != this && !isPulling) {
                this.pulled = true;
                this.puller = player.func_184187_bx();
                if (this.puller instanceof EntityHorse) {
                    this.setPullerType(1);
                } else if (this.puller instanceof EntityAnimaniaPig) {
                    this.setPullerType(3);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                return true;
            }
            if (player.func_184218_aH() && this.puller == player.func_184187_bx() && player.func_184187_bx() != this) {
                this.pulled = false;
                this.puller = null;
                this.setPullerType(0);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                this.stopCart();
                return true;
            }
            if (!(stack.func_77973_b() != Items.field_190931_a && stack.func_77973_b() != Items.field_151058_ca || horse == null || horse.func_110166_bE() != player || isPulling)) {
                this.pulled = true;
                this.puller = horse;
                this.setPullerType(1);
                horse.func_110160_i(true, false);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151058_ca, 1));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                return true;
            }
            if (!(stack.func_77973_b() != Items.field_190931_a && stack.func_77973_b() != Items.field_151058_ca || pig == null || pig.func_110166_bE() != player || isPulling)) {
                this.pulled = true;
                this.puller = pig;
                this.setPullerType(3);
                pig.func_110160_i(true, false);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151058_ca, 1));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                return true;
            }
            if (stack.func_190926_b() && !player.func_184218_aH() && this.puller != player && this.func_184179_bs() != player && !this.field_70170_p.field_72995_K && !isPulling) {
                double diffx = Math.abs(this.field_70165_t - player.field_70165_t);
                double diffy = Math.abs(this.field_70163_u - player.field_70163_u);
                double diffz = Math.abs(this.field_70161_v - player.field_70161_v);
                if (diffx > 0.0 && diffy < 2.0 && diffz > 0.0) {
                    this.pulled = true;
                    this.puller = player;
                    this.setPullerType(2);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                    }
                }
                return true;
            }
            if (stack.func_190926_b() && !player.func_184218_aH() && this.puller == player && this.func_184179_bs() != player && !this.field_70170_p.field_72995_K) {
                this.pulled = false;
                this.puller = null;
                this.setPullerType(0);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                this.stopCart();
                return true;
            }
            this.pulled = false;
            this.puller = null;
            this.setPullerType(0);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FarmAddonSoundHandler.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
            }
            this.stopCart();
            return true;
        }
        return true;
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
        }
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setHasChest(boolean hasChest) {
        this.field_70180_af.func_187227_b(HAS_CHEST, (Object)hasChest);
    }

    public boolean getHasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CHEST);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityCart) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e && !this.pulled) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b && !this.pulled) {
            super.func_70108_f(entityIn);
        }
    }

    public void func_70071_h_() {
        List list;
        EntityAnimal entityanimal;
        EntityPlayer player;
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer && this.field_184245_j == 0 && (player = (EntityPlayer)this.func_184179_bs()).func_70093_af()) {
            player.func_70108_f((Entity)this);
            this.func_184210_p();
            player.func_110145_l((Entity)this);
            this.func_184226_ay();
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityAnimal && (entityanimal = (EntityAnimal)this.func_184179_bs()).func_184207_aI() && entityanimal.func_184179_bs() instanceof EntityPlayer) {
            entityanimal.func_70108_f((Entity)this);
            entityanimal.func_184210_p();
            this.func_184210_p();
            entityanimal.func_110145_l((Entity)this);
            entityanimal.func_184226_ay();
            this.func_184226_ay();
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer && this.field_184245_j > 10 && this.field_70170_p.field_72995_K) {
            player = (EntityPlayer)this.func_184179_bs();
            player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()})), true);
        }
        if (this.pulled && this.puller != null && this.field_70170_p.field_72995_K) {
            double movX = Math.abs(this.field_70165_t - this.field_70169_q);
            double movZ = Math.abs(this.field_70161_v - this.field_70166_s);
            double moveThresh = 0.005;
            if (this.cartYaw < 0.0 && this.field_70159_w > 0.001 && this.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
            } else if (this.cartYaw > 0.0 && this.field_70159_w < -0.001 && this.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
            } else if (this.cartYaw > 0.0 && this.field_70159_w < -0.001 && this.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
            } else if (this.cartYaw < 0.0 && this.field_70159_w > 0.001 && this.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
            } else if (this.cartYaw < 0.0 && this.field_70159_w < -0.001 && this.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
            } else if (this.cartYaw > 0.0 && this.field_70159_w > 0.001 && this.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
            } else if (this.cartYaw > 0.0 && this.field_70159_w > 0.001 && this.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
            } else if (this.cartYaw < 0.0 && this.field_70159_w < -0.001 && this.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                    this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                    this.getAnimationHandler().startAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
                }
            }
        }
        if (this.pulled && this.puller instanceof EntityPlayer) {
            List carts = AnimaniaHelper.getEntitiesInRangeGeneric(EntityCart.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
            EntityPlayer player2 = (EntityPlayer)this.puller;
            int totPulling = 0;
            if (!carts.isEmpty()) {
                if (carts.size() > 1) {
                    for (int i = 0; i < carts.size(); ++i) {
                        EntityCart tempCart = (EntityCart)((Object)carts.get(i));
                        if (!tempCart.pulled || tempCart.puller != player2 || tempCart == this) continue;
                        ++totPulling;
                    }
                }
                if (totPulling > 0) {
                    player2.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, carts.size() + 1, false, false));
                }
            }
        }
        if (this.pulled && this.puller instanceof EntityAnimal) {
            List carts = AnimaniaHelper.getEntitiesInRangeGeneric(EntityCart.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
            List wagons = AnimaniaHelper.getEntitiesInRangeGeneric(EntityWagon.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
            List tillers = AnimaniaHelper.getEntitiesInRangeGeneric(EntityTiller.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
            EntityAnimal animal = (EntityAnimal)this.puller;
            if (carts.size() + wagons.size() + tillers.size() > 1) {
                if (!carts.isEmpty() && carts.size() > 1) {
                    for (int i = 0; i < carts.size(); ++i) {
                        EntityCart tempCart = (EntityCart)((Object)carts.get(i));
                        if (!tempCart.pulled || tempCart.puller != animal || tempCart == this) continue;
                        tempCart.pulled = false;
                        tempCart.puller = null;
                    }
                }
                if (!wagons.isEmpty() && wagons.size() > 1) {
                    for (int i = 0; i < wagons.size(); ++i) {
                        EntityWagon tempWagon = (EntityWagon)((Object)wagons.get(i));
                        if (!tempWagon.pulled || tempWagon.puller != animal) continue;
                        tempWagon.pulled = false;
                        tempWagon.puller = null;
                    }
                }
                if (!tillers.isEmpty() && tillers.size() > 1) {
                    for (int i = 0; i < tillers.size(); ++i) {
                        EntityTiller tempTiller = (EntityTiller)((Object)tillers.get(i));
                        if (!tempTiller.pulled || tempTiller.puller != animal) continue;
                        tempTiller.pulled = false;
                        tempTiller.puller = null;
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.pulled) {
            double diffX = this.field_70165_t - this.field_70169_q;
            double diffZ = this.field_70161_v - this.field_70166_s;
            double movX = Math.abs(this.field_70165_t - this.field_70169_q);
            double movZ = Math.abs(this.field_70161_v - this.field_70166_s);
            double moveThresh = 0.008;
            if (diffX < 0.005 && diffZ < 0.005 && movX + movZ < moveThresh && this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
                this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
            }
            if (diffX < 0.005 && diffZ < 0.005 && movX + movZ < moveThresh && this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
                this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
            }
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.pulled && this.puller == null && this.getPullerType() > 0) {
            if (this.getPullerType() == 1) {
                List entities = AnimaniaHelper.getEntitiesInRange(EntityHorse.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
                if (!entities.isEmpty()) {
                    this.puller = (Entity)entities.get(0);
                    this.pulled = true;
                    this.setPullerType(1);
                }
            } else if (this.getPullerType() == 2) {
                List entities = AnimaniaHelper.getEntitiesInRange(EntityPlayer.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
                if (!entities.isEmpty()) {
                    this.puller = (Entity)entities.get(0);
                    this.pulled = true;
                    this.setPullerType(2);
                }
            } else if (this.getPullerType() == 3) {
                List entities = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPig.class, (double)3.0, (World)this.field_70170_p, (Entity)this);
                if (!entities.isEmpty()) {
                    this.puller = (Entity)entities.get(0);
                    this.pulled = true;
                    this.setPullerType(3);
                }
            } else {
                this.pulled = false;
                this.setPullerType(0);
            }
        }
        if (this.pulled && this.puller != null && this.puller.func_184218_aH()) {
            this.puller = this.puller.func_184187_bx();
            if (this.puller instanceof EntityHorse) {
                this.setPullerType(1);
            } else if (this.puller instanceof EntityAnimaniaPig) {
                this.setPullerType(3);
            }
        }
        if (this.puller != null && (Math.abs(this.puller.field_70165_t - this.field_70165_t) > 5.0 || Math.abs(this.puller.field_70161_v - this.field_70161_v) > 5.0)) {
            this.pulled = false;
            this.puller = null;
            this.setPullerType(0);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, FarmAddonSoundHandler.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
            this.stopCart();
        }
        if (this.pulled) {
            double deltaAngle = -Math.atan2(this.puller.field_70165_t - this.field_70165_t, this.puller.field_70161_v - this.field_70161_v);
            Vec3d vec = new Vec3d(this.puller.field_70165_t, this.puller.field_70163_u, this.puller.field_70161_v).func_178788_d(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_178787_e(new Vec3d(0.0, 0.0, -2.5).func_178785_b((float)(-deltaAngle)));
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this))).isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K;
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (!(entity instanceof EntityAnimal)) continue;
                EntityAnimal entityanimal2 = (EntityAnimal)entity;
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && this.puller != entity && entityanimal2.func_110167_bD() && entityanimal2.func_110166_bE() instanceof EntityPlayer && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
        if (!this.pulled) {
            this.field_70181_x -= 0.05;
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
        }
        super.func_70071_h_();
        this.tickLerp();
    }

    public void stopCart() {
        if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest", (IAnimated)this)) {
            this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest", (IAnimated)this);
        }
        if (this.getAnimationHandler().isAnimationActive("animania", "anim_cart_chest_back", (IAnimated)this)) {
            this.getAnimationHandler().stopAnimation("animania", "anim_cart_chest_back", (IAnimated)this);
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.cartPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.cartYaw - (double)this.field_70177_z));
            if (this.puller != null) {
                double deltaAngle = -Math.atan2(this.puller.field_70165_t - this.field_70165_t, this.puller.field_70161_v - this.field_70161_v);
                this.field_70177_z = (float)Math.toDegrees(deltaAngle);
            }
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.cartPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.cartYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)0.0f, (float)0.0f);
        if (entityToUpdate instanceof EntityPlayer) {
            f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        }
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_145778_a(FarmAddonItemHandler.cart, 1, 0.0f);
                    if (this.getHasChest()) {
                        InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (IInventory)this.cartChest);
                        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150486_ae), 1, 0.0f);
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        double movX = Math.abs(this.field_70165_t - this.field_70169_q);
        double movZ = Math.abs(this.field_70161_v - this.field_70166_s);
        if (entityIn == this.puller) {
            return null;
        }
        if (this.pulled) {
            return null;
        }
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this instanceof EntityCart) {
            return new ItemStack(FarmAddonItemHandler.cart);
        }
        return ItemStack.field_190927_a;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PULLER_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(HAS_CHEST, (Object)false);
    }

    public int getPullerType() {
        return (Integer)this.field_70180_af.func_187225_a(PULLER_TYPE);
    }

    public void setPullerType(int pullerType) {
        this.field_70180_af.func_187227_b(PULLER_TYPE, (Object)pullerType);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("PullerType", this.getPullerType());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.cartChest.func_70302_i_(); ++i) {
            ItemStack itemstack = this.cartChest.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74757_a("HasChest", this.getHasChest());
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setPullerType(compound.func_74762_e("PullerType"));
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.initCartChest();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.cartChest.func_70302_i_()) continue;
            this.cartChest.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.setHasChest(compound.func_74767_n("HasChest"));
    }

    public int determinePullerType(Entity entity) {
        int pullerType = 0;
        if (entity instanceof EntityHorse) {
            pullerType = 1;
        } else if (entity instanceof EntityPlayer) {
            pullerType = 2;
        } else if (entity instanceof EntityAnimaniaPig) {
            pullerType = 3;
        }
        return pullerType;
    }

    public void initCartChest() {
        CartChest horsecartchest = this.cartChest;
        this.cartChest = new CartChest("cartChest", 36);
        this.cartChest.func_110133_a(this.func_70005_c_());
        if (horsecartchest != null) {
            horsecartchest.func_110132_b(this);
            int i = Math.min(horsecartchest.func_70302_i_(), this.cartChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = horsecartchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.cartChest.func_70299_a(j, itemstack.func_77946_l());
            }
            horsecartchest = null;
        }
        this.cartChest.func_110134_a(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void func_76316_a(IInventory invBasic) {
    }

    static {
        animHandler.addAnim("animania", "anim_cart", "model_cart", true);
        animHandler.addAnim("animania", "anim_cart_back", "anim_cart");
        animHandler.addAnim("animania", "anim_cart_chest", "model_cart_chest", true);
        animHandler.addAnim("animania", "anim_cart_chest_back", "anim_cart_chest");
    }
}

