/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;

public class FixedSizeList<E>
extends AbstractList<E> {
    public static final int DEFAULT_CAPACITY = 64;
    private final E[] allTheData;
    private final int capacity;
    private int size;

    public FixedSizeList() {
        this.capacity = 64;
        this.allTheData = new Object[64];
    }

    public FixedSizeList(int capacity) {
        if (capacity <= 0) {
            capacity = 64;
        }
        this.capacity = capacity;
        this.allTheData = new Object[this.capacity];
    }

    private FixedSizeList(@Nonnull Collection<E> collection) {
        this.capacity = this.size = collection.size();
        this.allTheData = Arrays.copyOf(collection.toArray(), this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean add(E e) {
        if (this.size == this.capacity) {
            return false;
        }
        this.allTheData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E e) {
        this.allTheData[index] = e;
    }

    @Override
    public E get(int index) {
        if (index > this.size) {
            return null;
        }
        return this.allTheData[index];
    }

    @Override
    public E remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        E removed = this.allTheData[index];
        if (this.size != 1) {
            System.arraycopy(this.allTheData, index + 1, this.allTheData, index, this.size - index - 1);
        }
        this.allTheData[--this.size] = null;
        return removed;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return Arrays.copyOf(this.allTheData, this.size);
    }

    @Override
    public void clear() {
        ++this.modCount;
        while (this.size > 0) {
            this.allTheData[--this.size] = null;
        }
    }
}

