/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemDice
extends ItemRelic {
    public static ItemStack[] relicStacks;

    public ItemDice() {
        super("dice");
        relicStacks = new ItemStack[]{new ItemStack(ModItems.infiniteFruit), new ItemStack(ModItems.kingKey), new ItemStack(ModItems.flugelEye), new ItemStack(ModItems.thorRing), new ItemStack(ModItems.odinRing), new ItemStack(ModItems.lokiRing)};
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isRightPlayer(player, stack)) {
            if (world.field_72995_K) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            ArrayList<Integer> possible = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                if (this.hasRelicAlready(player, i)) continue;
                possible.add(i);
            }
            if (possible.isEmpty()) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.dudDiceRoll", new Object[]{world.field_73012_v.nextInt(6) + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
                stack.func_190918_g(1);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            int relic = (Integer)possible.get(world.field_73012_v.nextInt(possible.size()));
            player.func_145747_a(new TextComponentTranslation("botaniamisc.diceRoll", new Object[]{relic + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)relicStacks[relic].func_77946_l());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public boolean shouldDamageWrongPlayer() {
        return false;
    }

    private boolean hasRelicAlready(EntityPlayer player, int relic) {
        if (relic < 0 || relic > relicStacks.length || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
        Item item = relicStacks[relic].func_77973_b();
        ResourceLocation advId = ((IRelic)item).getAdvancement();
        if (advId != null) {
            Advancement adv = mpPlayer.func_71121_q().func_191952_z().func_192778_a(advId);
            return adv != null && mpPlayer.func_192039_O().func_192747_a(adv).func_192105_a();
        }
        return false;
    }
}

