/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.init.ModItems;
import xreliquary.util.potions.XRPotionHelper;

public class HandgunPane
extends Component {
    Box mainPane;
    ItemStackPane[] bulletPanes = new ItemStackPane[8];
    ItemStackPane magazinePane;
    EnumHand hand;
    int time = 0;

    public HandgunPane(EnumHand hand) {
        this.hand = hand;
        this.magazinePane = new ItemStackPane(ModItems.magazine);
        for (int i = 0; i < 8; ++i) {
            this.bulletPanes[i] = new ItemStackPane(ItemStack.field_190927_a){

                @Override
                public int getPadding() {
                    return -3;
                }
            };
        }
        Box bulletsPane = new Box(Box.Layout.HORIZONTAL, Box.Alignment.MIDDLE, (Component[])this.bulletPanes){

            @Override
            public int getPadding() {
                return 3;
            }
        };
        this.mainPane = hand == EnumHand.OFF_HAND ? Box.createHorizontal(Box.Alignment.MIDDLE, new ItemStackPane(ModItems.handgun), this.magazinePane, bulletsPane) : Box.createHorizontal(Box.Alignment.MIDDLE, bulletsPane, this.magazinePane, new ItemStackPane(ModItems.handgun));
    }

    @Override
    public int getHeightInternal() {
        return this.mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPane.getWidth();
    }

    @Override
    public int getHeight() {
        return this.holdsHandgun() ? super.getHeight() : 0;
    }

    @Override
    public boolean shouldRender() {
        return this.holdsHandgun();
    }

    private boolean holdsHandgun() {
        return Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand).func_77973_b() == ModItems.handgun;
    }

    @Override
    public void renderInternal(int x, int y) {
        ItemStack handgun = Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand);
        if (handgun.func_190926_b()) {
            return;
        }
        ItemStack bullets = HandgunPane.getBulletStackFromHandgun(handgun);
        for (int i = 0; i < 8; ++i) {
            if (i < bullets.func_190916_E()) {
                this.bulletPanes[i].setItemStack(bullets);
                continue;
            }
            this.bulletPanes[i].setItemStack(ItemStack.field_190927_a);
        }
        if (bullets.func_190926_b() && this.getTime() % 32 > 16) {
            this.magazinePane.setItem(ModItems.magazine);
        } else {
            this.magazinePane.setItemStack(ItemStack.field_190927_a);
        }
        this.mainPane.render(x, y);
    }

    private int getTime() {
        ++this.time;
        if (this.time > 31) {
            this.time = 0;
        }
        return this.time;
    }

    private static ItemStack getBulletStackFromHandgun(ItemStack handgun) {
        ItemStack bulletStack = new ItemStack((Item)ModItems.bullet, (int)ModItems.handgun.getBulletCount(handgun), (int)ModItems.handgun.getBulletType(handgun));
        List<PotionEffect> potionEffects = ModItems.handgun.getPotionEffects(handgun);
        if (potionEffects != null && !potionEffects.isEmpty()) {
            XRPotionHelper.addPotionEffectsToStack(bulletStack, potionEffects);
        }
        return bulletStack;
    }
}

