/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.potion;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import xreliquary.init.ModItems;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;
import xreliquary.util.potions.XRPotionHelper;

public class EntityThrownXRPotion
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private int renderColor;
    private boolean lingering = false;
    private List<PotionEffect> effects;

    public EntityThrownXRPotion(World world) {
        super(world);
    }

    public EntityThrownXRPotion(World world, double x, double y, double z, ItemStack potion) {
        super(world, x, y, z);
        this.setEffects(potion);
        this.lingering = ModItems.potion.isLingering(potion);
    }

    private void setEffects(ItemStack ist) {
        this.effects = XRPotionHelper.getPotionEffectsFromStack(ist);
        this.setRenderColor(this.getColor());
    }

    public EntityThrownXRPotion(World world, EntityLivingBase elb, ItemStack potion) {
        super(world, elb);
        this.setEffects(potion);
        this.lingering = ModItems.potion.isLingering(potion);
    }

    protected float func_70185_h() {
        return 0.04f;
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb;
            List livingEntities;
            if (this.lingering) {
                EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entityareaeffectcloud.func_184481_a(this.func_85052_h());
                entityareaeffectcloud.func_184483_a(3.0f);
                entityareaeffectcloud.func_184495_b(-0.5f);
                entityareaeffectcloud.func_184485_d(10);
                entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                entityareaeffectcloud.func_184482_a(this.renderColor);
                for (PotionEffect potioneffect : this.effects) {
                    entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect.func_188419_a(), potioneffect.func_76459_b(), potioneffect.func_76458_c()));
                }
                this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
            } else if (this.effects != null && !this.effects.isEmpty() && !(livingEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
                for (EntityLivingBase entitylivingbase : livingEntities) {
                    double d0 = this.func_70032_d((Entity)entitylivingbase);
                    if (!(d0 < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                    if (entitylivingbase == result.field_72308_g) {
                        d1 = 1.0;
                    }
                    XRPotionHelper.applyEffectsToEntity(this.effects, (Entity)this, (Entity)this.func_85052_h(), entitylivingbase, d1);
                }
            }
            this.spawnParticles();
            this.func_70106_y();
        }
    }

    public int getColor() {
        return this.effects == null ? this.getRenderColor() : PotionUtils.func_185181_a(this.effects);
    }

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Random var7 = this.field_70146_Z;
        for (int var15 = 0; var15 < 8; ++var15) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)Items.field_151068_bn)});
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.networkWrapper.sendToAllAround((IMessage)new PacketFXThrownPotionImpact(this.getColor(), this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(tag);
        this.setRenderColor(tag.func_74762_e("color"));
        this.lingering = tag.func_74767_n("lingering");
        if (this.effects.isEmpty()) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        XRPotionHelper.addPotionEffectsToCompoundTag(tag, this.effects);
        tag.func_74768_a("color", this.getRenderColor());
        tag.func_74757_a("lingering", this.lingering);
    }

    public int getRenderColor() {
        return this.renderColor;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.renderColor);
        buffer.writeBoolean(this.lingering);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setRenderColor(additionalData.readInt());
        this.lingering = additionalData.readBoolean();
    }

    private void setRenderColor(int renderColor) {
        this.renderColor = renderColor;
    }

    public boolean getLingering() {
        return this.lingering;
    }
}

