/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.entities.EntityXRFakePlayer;
import xreliquary.init.ModBlocks;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.VoidTearItemStackHandler;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.WorldHelper;
import xreliquary.util.XRFakePlayerFactory;

@MethodsReturnNonnullByDefault
public class ItemVoidTear
extends ItemToggleable {
    public ItemVoidTear() {
        super("void_tear");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String func_77667_c(ItemStack stack) {
        return "item.void_tear";
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isEmpty(stack) ? 16 : 1;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            VoidTearItemStackHandler itemHandler = new VoidTearItemStackHandler();

            public NBTTagCompound serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.itemHandler.deserializeNBT(nbt);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)this.itemHandler;
                }
                return null;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) && super.func_77636_d(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addMoreInformation(ItemStack voidTear, @Nullable World world, List<String> tooltip) {
        ItemStack contents = this.getContainerItem(voidTear, true);
        if (this.isEmpty(voidTear, true)) {
            return;
        }
        if (this.isEnabled(voidTear)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + contents.func_82833_r())), tooltip);
            tooltip.add(LanguageHelper.getLocalization("tooltip.absorb_tear", new Object[0]));
        }
        LanguageHelper.formatTooltip("tooltip.tear_quantity", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)contents.func_82833_r(), (Object)"amount", (Object)Integer.toString(contents.func_190916_E())), tooltip);
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack voidTear = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            RayTraceResult rayTraceResult = this.func_77621_a(world, player, false);
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && (InventoryHelper.hasItemHandler(world, rayTraceResult.func_178782_a()) && player.func_70093_af() || this.getContainerItem(voidTear).func_77973_b() instanceof ItemBlock)) {
                return new ActionResult(EnumActionResult.PASS, (Object)voidTear);
            }
            if (this.isEmpty(voidTear)) {
                return this.rightClickEmpty(voidTear, player);
            }
            if (this.getItemQuantity(voidTear) == 0) {
                this.setEmpty(voidTear);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)voidTear);
            }
            if (player.func_70093_af()) {
                return super.func_77659_a(world, player, hand);
            }
            if (this.attemptToEmptyIntoInventory(voidTear, player, InventoryHelper.getItemHandlerFrom(player))) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                this.setEmpty(voidTear);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)voidTear);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)voidTear);
    }

    private ActionResult<ItemStack> rightClickEmpty(ItemStack emptyVoidTear, EntityPlayer player) {
        IItemHandler playerInventory = InventoryHelper.getItemHandlerFrom(player);
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, playerInventory);
        if (!target.func_190926_b()) {
            ItemStack filledTear;
            if (emptyVoidTear.func_190916_E() > 1) {
                emptyVoidTear.func_190918_g(1);
                filledTear = new ItemStack((Item)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, playerInventory, true);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            if (emptyVoidTear.func_190916_E() == 1) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledTear);
            }
            InventoryHelper.addItemToPlayerInventory(player, filledTear);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)emptyVoidTear);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)emptyVoidTear);
    }

    private void buildTear(ItemStack voidTear, ItemStack target, EntityPlayer player, IItemHandler inventory, boolean isPlayerInventory) {
        this.setItemStack(voidTear, target);
        int quantity = InventoryHelper.getItemQuantity(target, inventory);
        if (isPlayerInventory) {
            if (quantity - target.func_77976_d() > 0) {
                InventoryHelper.consumeItem(target, player, target.func_77976_d(), quantity - target.func_77976_d());
                quantity -= target.func_77976_d();
            } else {
                InventoryHelper.consumeItem(target, player, 0, 1);
                quantity = 1;
            }
        } else {
            quantity = InventoryHelper.tryToRemoveFromInventory(target, inventory, Settings.Items.VoidTear.itemLimit);
        }
        this.setItemQuantity(voidTear, quantity);
        NBTHelper.setBoolean("enabled", voidTear, Settings.Items.VoidTear.absorbWhenCreated);
    }

    private boolean canPlaceBlockOnSide(World worldIn, Block blockToPlace, BlockPos pos, EnumFacing side, EntityPlayer player) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)worldIn, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return worldIn.func_190527_a(blockToPlace, pos, false, side, (Entity)player);
    }

    public void func_77663_a(ItemStack voidTear, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (!world.field_72995_K) {
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (this.isEnabled(voidTear)) {
                ItemStack contents = this.getContainerItem(voidTear);
                if (!contents.func_190926_b()) {
                    int itemQuantity = InventoryHelper.getItemQuantity(contents, InventoryHelper.getItemHandlerFrom(player));
                    if (this.getItemQuantity(voidTear) <= Settings.Items.VoidTear.itemLimit && itemQuantity > this.getKeepQuantity(voidTear) && InventoryHelper.consumeItem(contents, player, this.getKeepQuantity(voidTear), itemQuantity - this.getKeepQuantity(voidTear)) && !player.field_71075_bZ.field_75098_d) {
                        this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - this.getKeepQuantity(voidTear));
                    }
                    if (this.getMode(voidTear) != Mode.NO_REFILL) {
                        this.attemptToReplenish(player, voidTear);
                    }
                } else {
                    this.setEmpty(voidTear);
                }
            }
        }
    }

    private void attemptToReplenish(EntityPlayer player, ItemStack voidTear) {
        int quantityToDecrease;
        int slot;
        IItemHandler inventory = InventoryHelper.getItemHandlerFrom(player);
        for (slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stackFound = inventory.getStackInSlot(slot);
            if (!StackHelper.isItemAndNbtEqual(stackFound, this.getContainerItem(voidTear))) continue;
            quantityToDecrease = Math.min(stackFound.func_77976_d() - stackFound.func_190916_E(), this.getItemQuantity(voidTear) - 1);
            stackFound.func_190917_f(quantityToDecrease);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return;
        }
        while (this.getItemQuantity(voidTear) > 1 && (slot = player.field_71071_by.func_70447_i()) != -1) {
            ItemStack newStack = this.getContainerItem(voidTear).func_77946_l();
            quantityToDecrease = Math.min(newStack.func_77976_d(), this.getItemQuantity(voidTear) - 1);
            newStack.func_190920_e(quantityToDecrease);
            player.field_71071_by.func_70299_a(slot, newStack);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return;
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack containerItem;
        ItemBlock itemBlock;
        Block block;
        ItemStack voidTear = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.pedestal) {
            return EnumActionResult.PASS;
        }
        Optional handler = WorldHelper.getTile((IBlockAccess)world, pos).map(InventoryHelper::getItemHandlerFrom).orElse(Optional.empty());
        if (handler.isPresent()) {
            if (!world.field_72995_K) {
                IItemHandler itemHandler = (IItemHandler)handler.get();
                if (this.isEmpty(voidTear)) {
                    return this.onItemUseFirstEmpty(voidTear, itemHandler, player, hand);
                }
                if (this.isEnabled(voidTear)) {
                    this.drainInventory(voidTear, player, itemHandler);
                } else {
                    this.attemptToEmptyIntoInventory(voidTear, player, itemHandler);
                    if (this.getItemQuantity(voidTear) <= 0) {
                        this.setEmpty(voidTear);
                        player.func_184611_a(hand, voidTear);
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.getContainerItem(voidTear).func_77973_b() instanceof ItemBlock && this.getItemQuantity(voidTear) > 0 && this.canPlaceBlockOnSide(world, block = (itemBlock = (ItemBlock)(containerItem = this.getContainerItem(voidTear)).func_77973_b()).func_179223_d(), pos, side, player)) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - 1);
            if (!world.field_72995_K) {
                EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((WorldServer)world);
                fakePlayer.func_184611_a(EnumHand.MAIN_HAND, containerItem);
                itemBlock.func_180614_a((EntityPlayer)fakePlayer, world, pos, hand, side, hitX, hitY, hitZ);
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult onItemUseFirstEmpty(ItemStack emptyVoidTear, IItemHandler inventory, EntityPlayer player, EnumHand hand) {
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, inventory);
        if (!target.func_190926_b()) {
            ItemStack filledTear;
            if (emptyVoidTear.func_190916_E() > 1) {
                emptyVoidTear.func_190918_g(1);
                filledTear = new ItemStack((Item)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, inventory, false);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            if (emptyVoidTear.func_190916_E() == 1) {
                player.func_184611_a(hand, filledTear);
            } else {
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean attemptToEmptyIntoInventory(ItemStack ist, EntityPlayer player, IItemHandler inventory) {
        ItemStack contents = this.getContainerItem(ist).func_77946_l();
        contents.func_190920_e(1);
        int quantity = this.getItemQuantity(ist);
        int maxNumberToEmpty = player.func_70093_af() ? quantity : Math.min(contents.func_77976_d(), quantity);
        this.setItemQuantity(ist, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty));
        if (quantity == 0) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        return false;
    }

    private void drainInventory(ItemStack ist, EntityPlayer player, IItemHandler inventory) {
        int quantity;
        ItemStack contents = this.getContainerItem(ist);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, Settings.Items.VoidTear.itemLimit - (quantity = this.getItemQuantity(ist)));
        if (quantityDrained <= 0) {
            return;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        this.setItemQuantity(ist, quantity + quantityDrained);
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack voidTear) {
        NBTTagCompound nbt = super.getNBTShareTag(voidTear);
        if (this.isEmpty(voidTear)) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("count", this.getItemQuantity(voidTear));
        nbt.func_74782_a("contents", (NBTBase)this.getContainerItem(voidTear).func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack voidTear) {
        return this.getContainerItem(voidTear, false);
    }

    public ItemStack getContainerItem(@Nonnull ItemStack voidTear, boolean isClient) {
        if (isClient) {
            NBTTagCompound nbt = voidTear.func_77978_p();
            if (nbt == null || !nbt.func_74764_b("contents")) {
                return ItemStack.field_190927_a;
            }
            ItemStack contents = new ItemStack(nbt.func_74775_l("contents"));
            contents.func_190920_e(nbt.func_74762_e("count"));
            return contents;
        }
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return ItemStack.field_190927_a;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        ItemStack stackToReturn = ItemStack.field_190927_a;
        if (!filteredHandler.getStackInParentSlot(0).func_190926_b()) {
            stackToReturn = filteredHandler.getStackInParentSlot(0).func_77946_l();
            stackToReturn.func_190920_e(filteredHandler.getTotalAmount(0));
        }
        return stackToReturn;
    }

    private void setItemStack(ItemStack voidTear, ItemStack stack) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setParentSlotStack(0, stack);
    }

    private void setItemQuantity(ItemStack voidTear, int quantity) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, quantity);
    }

    private int getItemQuantity(ItemStack voidTear) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack voidTear) {
        if (entityLiving.field_70170_p.field_72995_K || !(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(voidTear);
            return true;
        }
        return false;
    }

    public Mode getMode(ItemStack voidTear) {
        if (NBTHelper.getString("mode", voidTear).isEmpty()) {
            this.setMode(voidTear, Mode.ONE_STACK);
        }
        return Mode.valueOf(NBTHelper.getString("mode", voidTear));
    }

    private void setMode(ItemStack voidTear, Mode mode) {
        NBTHelper.setString("mode", voidTear, mode.toString());
    }

    private void cycleMode(ItemStack voidTear) {
        if (this.isEmpty(voidTear)) {
            return;
        }
        Mode mode = this.getMode(voidTear);
        switch (mode) {
            case ONE_STACK: {
                this.setMode(voidTear, Mode.FULL_INVENTORY);
                break;
            }
            case FULL_INVENTORY: {
                this.setMode(voidTear, Mode.NO_REFILL);
                break;
            }
            case NO_REFILL: {
                this.setMode(voidTear, Mode.ONE_STACK);
            }
        }
    }

    private int getKeepQuantity(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        if (mode == Mode.NO_REFILL) {
            return 0;
        }
        if (mode == Mode.ONE_STACK) {
            return this.getContainerItem(voidTear).func_77976_d();
        }
        return Integer.MAX_VALUE;
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack pickedUpStack = event.getItem().func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        EntityItem itemEntity = event.getItem();
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            int playerItemQuantity;
            ItemStack tearStack = player.field_71071_by.func_70301_a(slot);
            if (tearStack.func_77973_b() != this || !this.isEnabled(tearStack)) continue;
            int tearItemQuantity = this.getItemQuantity(tearStack);
            if (!this.canAbsorbStack(pickedUpStack, tearStack) || (playerItemQuantity = InventoryHelper.getItemQuantity(pickedUpStack, InventoryHelper.getItemHandlerFrom(player))) + pickedUpStack.func_190916_E() < this.getKeepQuantity(tearStack) && player.field_71071_by.func_70447_i() != -1) continue;
            this.setItemQuantity(tearStack, tearItemQuantity + pickedUpStack.func_190916_E());
            if (!itemEntity.func_174814_R()) {
                Random rand = new Random();
                itemEntity.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.func_70106_y();
            event.setCanceled(true);
            break;
        }
    }

    boolean canAbsorbStack(ItemStack pickedUpStack, ItemStack tearStack) {
        return StackHelper.isItemAndNbtEqual(this.getContainerItem(tearStack), pickedUpStack) && this.getItemQuantity(tearStack) + pickedUpStack.func_190916_E() <= Settings.Items.VoidTear.itemLimit;
    }

    public boolean isEmpty(ItemStack voidTear) {
        return this.isEmpty(voidTear, false);
    }

    public boolean isEmpty(ItemStack voidTear, boolean isClient) {
        if (isClient) {
            return this.getContainerItem(voidTear, true).func_190926_b();
        }
        return voidTear.func_77978_p() == null || voidTear.func_77978_p().func_150296_c().isEmpty();
    }

    private void setEmpty(ItemStack voidTear) {
        voidTear.func_77982_d(null);
        this.setItemStack(voidTear, ItemStack.field_190927_a);
        this.setItemQuantity(voidTear, 0);
    }

    public static enum Mode implements IStringSerializable
    {
        ONE_STACK,
        FULL_INVENTORY,
        NO_REFILL;


        @Nonnull
        public String func_176610_l() {
            return this.name();
        }
    }
}

