/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.util.NBTHelper;

public class PacketCountSync
implements IMessage,
IMessageHandler<PacketCountSync, IMessage> {
    private EnumHand hand = EnumHand.MAIN_HAND;
    private short slot;
    private ItemStack stack;
    private int count;

    public PacketCountSync() {
    }

    public PacketCountSync(EnumHand hand, short slot, int count) {
        this(hand, slot, ItemStack.field_190927_a, count);
    }

    public PacketCountSync(EnumHand hand, short slot, ItemStack stack, int count) {
        this.hand = hand;
        this.slot = slot;
        this.stack = stack;
        this.count = count;
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.slot = buf.readShort();
        try {
            this.stack = new ItemStack(CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        this.count = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        buf.writeShort((int)this.slot);
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.stack.func_77955_b(new NBTTagCompound()), (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        buf.writeInt(this.count);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketCountSync message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> this.handleMessage(message));
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleMessage(PacketCountSync message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack container = player.func_184586_b(message.hand);
        NBTHelper.updateContainedStack(container, message.slot, message.stack, message.count, message.stack.func_190926_b());
    }
}

