/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.tmel.common.modifiers;

import caffeinatedpinkie.tmel.LoggerTMEL;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public abstract class ValueModifier {
    public static List<ValueModifier> modifiers = new ArrayList<ValueModifier>();
    public String name;

    public static void add(ASMDataTable.ASMData data) {
        String className = data.getClassName();
        try {
            modifiers.add((ValueModifier)Class.forName(className).newInstance());
        }
        catch (ClassCastException e) {
            LoggerTMEL.warn("Annotated class " + className + " does not extend " + ValueModifier.class.getSimpleName() + '!', e);
        }
        catch (InstantiationException e) {
            LoggerTMEL.warn("Couldn't create an instance of " + className + " due to it missing a default constructor.", e);
        }
        catch (Exception e) {
            LoggerTMEL.warn("Unable to add modifier class to the load list: " + className + ".", e);
        }
    }

    public static void postInitEarly(FMLPostInitializationEvent event) {
        modifiers.forEach(modifier -> modifier.initateModifierInternal());
    }

    public static void postInitLate(FMLPostInitializationEvent event) {
        ValueModifier.refresh();
    }

    public static void refresh() {
        modifiers.forEach(modifier -> modifier.setValuesInternal());
    }

    public ValueModifier(String name) {
        this.name = name;
    }

    public void initateModifierInternal() {
        LoggerTMEL.log(() -> this.initiateModifier(), "Initiated " + this.name);
    }

    public abstract void initiateModifier();

    public abstract void setValues();

    public void setValuesInternal() {
        if (this.shouldSetValues()) {
            LoggerTMEL.log(() -> this.setValues(), "Set " + this.name + " values");
        }
    }

    public boolean shouldSetValues() {
        return true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Annotation {
    }
}

