/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.worsebarrels.WorseBarrels;
import quaternary.worsebarrels.block.EnumWorseBarrelOrientation;
import quaternary.worsebarrels.tile.TileWorseBarrel;

public class BlockWorseBarrel
extends Block {
    public static final PropertyEnum<EnumWorseBarrelOrientation> ORIENTATION = PropertyEnum.func_177709_a((String)"orientation", EnumWorseBarrelOrientation.class);

    public BlockWorseBarrel(Material mat) {
        super(mat, MapColor.field_151650_B);
        this.func_149711_c(1.2f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)EnumWorseBarrelOrientation.UPRIGHT_NORTH)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWorseBarrel();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileWorseBarrel) {
            return ((TileWorseBarrel)te).getComparatorOverride();
        }
        return 0;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult res = world.func_147447_a(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), false, true, false);
        if (res != null && res.field_178784_b != null) {
            IBlockState barrelState = world.func_180495_p(pos);
            if (barrelState.func_177230_c() != this || ((EnumWorseBarrelOrientation)((Object)barrelState.func_177229_b(BlockWorseBarrel.ORIENTATION))).facing != res.field_178784_b) {
                return;
            }
            WorseBarrels.PROXY.handleLeftClickBarrel(world, pos, player);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(world.func_175625_s(pos) instanceof TileWorseBarrel)) {
            player.func_146105_b((ITextComponent)new TextComponentString("Missing TileEntity?!"), true);
            return false;
        }
        IBlockState barrelState = world.func_180495_p(pos);
        if (barrelState.func_177230_c() != this || ((EnumWorseBarrelOrientation)((Object)barrelState.func_177229_b(BlockWorseBarrel.ORIENTATION))).facing != facing) {
            return false;
        }
        if (world.field_72995_K) {
            WorseBarrels.PROXY.handleRightClickBarrel(world, pos, player);
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        RayTraceResult res;
        if (player.func_184812_l_() && (res = world.func_147447_a(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), false, true, false)) != null && res.field_178784_b != null && ((EnumWorseBarrelOrientation)((Object)state.func_177229_b(BlockWorseBarrel.ORIENTATION))).facing == res.field_178784_b) {
            WorseBarrels.PROXY.handleLeftClickBarrel(world, pos, player);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileWorseBarrel) {
            TileWorseBarrel barrelTile = (TileWorseBarrel)te;
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            if (!barrelTile.isEmpty()) {
                NBTTagCompound stackNBT = new NBTTagCompound();
                stackNBT.func_74782_a("BlockEntityTag", (NBTBase)barrelTile.writeItemsOnlyToNBT(new NBTTagCompound()));
                stack.func_77982_d(stackNBT);
            }
            BlockWorseBarrel.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag mistake) {
        super.func_190948_a(stack, world, tooltip, mistake);
        NBTTagCompound stackNBT = stack.func_77978_p();
        if (stackNBT != null && stackNBT.func_150297_b("BlockEntityTag", 10)) {
            NBTTagCompound barrelNBT = stackNBT.func_74775_l("BlockEntityTag");
            if (!barrelNBT.func_150297_b("Contents", 10)) {
                return;
            }
            NBTTagCompound contentsNBT = barrelNBT.func_74775_l("Contents");
            if (!contentsNBT.func_150297_b("BarrelCount", 3)) {
                return;
            }
            int barrelCount = contentsNBT.func_74762_e("BarrelCount");
            if (!contentsNBT.func_150297_b("BarrelItem", 10)) {
                return;
            }
            ItemStack barrelStack = new ItemStack(contentsNBT.func_74775_l("BarrelItem"));
            StringBuilder bob = new StringBuilder();
            bob.append(barrelCount);
            bob.append("x ");
            bob.append(barrelStack.func_77953_t().field_77937_e);
            bob.append(barrelStack.func_82833_r());
            if (mistake.func_194127_a()) {
                bob.append(TextFormatting.WHITE);
                bob.append(" (#");
                bob.append(Item.func_150891_b((Item)barrelStack.func_77973_b()));
                bob.append('/');
                bob.append(barrelStack.func_77952_i());
                bob.append(')');
            }
            tooltip.add(bob.toString());
            ArrayList containedTooltip = new ArrayList();
            barrelStack.func_77973_b().func_77624_a(barrelStack, world, containedTooltip, mistake);
            for (String contained : containedTooltip) {
                tooltip.add("   " + contained);
            }
            if (mistake.func_194127_a()) {
                tooltip.add("   " + TextFormatting.DARK_GRAY + barrelStack.func_77973_b().getRegistryName());
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORIENTATION});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWorseBarrelOrientation)((Object)state.func_177229_b(ORIENTATION))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)EnumWorseBarrelOrientation.values()[meta]));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumWorseBarrelOrientation orient = Math.abs(placer.field_70125_A) > 65.0f || facing.func_176740_k() == EnumFacing.Axis.Y ? EnumWorseBarrelOrientation.fromEntityLiving(pos, placer) : EnumWorseBarrelOrientation.fromHorizontalFacing(facing);
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)orient));
    }
}

