/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.block;

import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;

public enum EnumWorseBarrelOrientation implements IStringSerializable
{
    UPRIGHT_NORTH(EnumFacing.NORTH, EnumFacing.UP),
    UPRIGHT_SOUTH(EnumFacing.SOUTH, EnumFacing.UP),
    UPRIGHT_EAST(EnumFacing.EAST, EnumFacing.UP),
    UPRIGHT_WEST(EnumFacing.WEST, EnumFacing.UP),
    CEILING_NORTH(EnumFacing.UP, EnumFacing.NORTH),
    CEILING_SOUTH(EnumFacing.UP, EnumFacing.SOUTH),
    CEILING_EAST(EnumFacing.UP, EnumFacing.EAST),
    CEILING_WEST(EnumFacing.UP, EnumFacing.WEST),
    FLOOR_NORTH(EnumFacing.DOWN, EnumFacing.NORTH),
    FLOOR_SOUTH(EnumFacing.DOWN, EnumFacing.SOUTH),
    FLOOR_EAST(EnumFacing.DOWN, EnumFacing.EAST),
    FLOOR_WEST(EnumFacing.DOWN, EnumFacing.WEST);

    public final EnumFacing facing;
    public final EnumFacing secondaryFacing;

    private EnumWorseBarrelOrientation(EnumFacing facing, EnumFacing secondaryFacing) {
        this.facing = facing;
        this.secondaryFacing = secondaryFacing;
    }

    EnumWorseBarrelOrientation rotateUp() {
        switch (this) {
            case UPRIGHT_NORTH: {
                return CEILING_NORTH;
            }
            case UPRIGHT_EAST: {
                return CEILING_EAST;
            }
            case UPRIGHT_SOUTH: {
                return CEILING_SOUTH;
            }
            case UPRIGHT_WEST: {
                return CEILING_WEST;
            }
        }
        throw new IllegalArgumentException("Not a horizontal facing: " + this.facing);
    }

    EnumWorseBarrelOrientation rotateDown() {
        switch (this) {
            case UPRIGHT_NORTH: {
                return FLOOR_NORTH;
            }
            case UPRIGHT_EAST: {
                return FLOOR_EAST;
            }
            case UPRIGHT_SOUTH: {
                return FLOOR_SOUTH;
            }
            case UPRIGHT_WEST: {
                return FLOOR_WEST;
            }
        }
        throw new IllegalArgumentException("Not a horizontal facing: " + this.facing);
    }

    public static EnumWorseBarrelOrientation fromHorizontalFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return UPRIGHT_NORTH;
            }
            case EAST: {
                return UPRIGHT_EAST;
            }
            case SOUTH: {
                return UPRIGHT_SOUTH;
            }
            case WEST: {
                return UPRIGHT_WEST;
            }
        }
        throw new IllegalArgumentException("Not a horizontal facing: " + facing);
    }

    public static EnumWorseBarrelOrientation fromFacingDirectional(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return CEILING_NORTH;
            }
            case DOWN: {
                return FLOOR_NORTH;
            }
        }
        return EnumWorseBarrelOrientation.fromHorizontalFacing(facing);
    }

    public static EnumWorseBarrelOrientation fromEntityLiving(BlockPos p, EntityLivingBase e) {
        EnumFacing livingFacing = EnumFacing.func_190914_a((BlockPos)p, (EntityLivingBase)e);
        if (livingFacing.func_176736_b() != -1) {
            return EnumWorseBarrelOrientation.fromHorizontalFacing(livingFacing);
        }
        EnumWorseBarrelOrientation flatRotation = EnumWorseBarrelOrientation.fromHorizontalFacing(e.func_174811_aO().func_176734_d());
        if (livingFacing == EnumFacing.UP) {
            return flatRotation.rotateUp();
        }
        return flatRotation.rotateDown();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

