/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.block;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import quaternary.worsebarrels.WorseBarrels;
import quaternary.worsebarrels.block.BlockWorseBarrel;

public final class WorseBarrelsBlocks {
    private static final List<String> COLOR_PREFIXES = Arrays.stream(EnumDyeColor.values()).map(EnumDyeColor::func_176610_l).map(s -> s + "_").collect(Collectors.toList());
    public static ImmutableList<BlockWorseBarrel> BARREL_BLOCKS = null;

    private WorseBarrelsBlocks() {
    }

    public static void registerBlocks(IForgeRegistry<Block> reg) {
        ImmutableList woodVariants = ImmutableList.of((Object)"oak", (Object)"spruce", (Object)"jungle", (Object)"acacia", (Object)"birch", (Object)"darkoak");
        List<String> stoneVariants = WorseBarrelsBlocks.multiplyColor(Stream.of("concrete", "stained_hardened_clay")).collect(Collectors.toList());
        ImmutableList.Builder bob = new ImmutableList.Builder();
        woodVariants.forEach(var -> bob.add((Object)WorseBarrelsBlocks.createBlock(new BlockWorseBarrel(Material.field_151575_d), "barrel_" + var)));
        stoneVariants.forEach(var -> bob.add((Object)WorseBarrelsBlocks.createBlock(new BlockWorseBarrel(Material.field_151576_e), "barrel_" + var)));
        BARREL_BLOCKS = bob.build();
        BARREL_BLOCKS.forEach(arg_0 -> reg.register(arg_0));
    }

    private static <T extends Block> T createBlock(T block, String name) {
        block.setRegistryName(new ResourceLocation("worsebarrels", name));
        block.func_149663_c("worsebarrels." + name);
        block.func_149647_a(WorseBarrels.TAB);
        return block;
    }

    private static Stream<String> multiplyColor(Stream<String> in) {
        return in.flatMap(s -> COLOR_PREFIXES.stream().map(prefix -> prefix + s));
    }
}

