/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.net;

import com.google.common.collect.Iterators;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import quaternary.worsebarrels.Util;
import quaternary.worsebarrels.WorseBarrels;
import quaternary.worsebarrels.WorseBarrelsConfig;
import quaternary.worsebarrels.etc.EnumItemCount;
import quaternary.worsebarrels.net.ByteBufUtils2;
import quaternary.worsebarrels.tile.TileWorseBarrel;

public class MessageInsertBarrelItem
implements IMessage {
    private BlockPos barrelPos;
    private EnumItemCount insertionType;

    public MessageInsertBarrelItem() {
    }

    public MessageInsertBarrelItem(BlockPos barrelPos, EnumItemCount insertionType) {
        this.barrelPos = barrelPos;
        this.insertionType = insertionType;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils2.writeBlockPos(buf, this.barrelPos);
        ByteBufUtils2.writeEnum(buf, this.insertionType);
    }

    public void fromBytes(ByteBuf buf) {
        this.barrelPos = ByteBufUtils2.readBlockPos(buf);
        this.insertionType = ByteBufUtils2.readEnum(buf, EnumItemCount.class);
    }

    public static class Handler
    implements IMessageHandler<MessageInsertBarrelItem, IMessage> {
        public IMessage onMessage(MessageInsertBarrelItem message, MessageContext ctx) {
            EntityPlayerMP inserter = ctx.getServerHandler().field_147369_b;
            WorldServer ws = inserter.func_71121_q();
            ws.func_152344_a(() -> {
                EnumHand activeHand;
                double barrelDistance;
                if (message.insertionType == null) {
                    Util.naughtyPlayer(ctx, "Tried to insert with invalid type");
                    return;
                }
                if (!ws.func_175667_e(message.barrelPos)) {
                    Util.naughtyPlayer(ctx, "Tried to insert to unloaded barrel");
                    return;
                }
                IAttributeInstance reachAttr = inserter.func_110140_aT().func_111151_a(EntityPlayerMP.REACH_DISTANCE);
                double reachDistanceSq = reachAttr.func_111126_e() * reachAttr.func_111126_e();
                if (reachDistanceSq < (barrelDistance = message.barrelPos.func_177951_i((Vec3i)inserter.func_180425_c())) + 1.0) {
                    WorseBarrels.LOGGER.info("Received out-of-range barrel insertion packet from " + ctx.getServerHandler().field_147369_b.func_70005_c_(), (Object)", this could be evidence of some sort of cheat mod, a bug on my end... or just lag x)");
                    return;
                }
                TileEntity tile = ws.func_175625_s(message.barrelPos);
                if (!(tile instanceof TileWorseBarrel)) {
                    return;
                }
                TileWorseBarrel barrel = (TileWorseBarrel)tile;
                IItemHandler handler = (IItemHandler)barrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (handler == null) {
                    return;
                }
                boolean handlerEmpty = Util.isHandlerEmpty(handler);
                EnumHand enumHand = activeHand = inserter.func_184614_ca().func_190926_b() ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                if (handlerEmpty) {
                    if (message.insertionType == EnumItemCount.ALL && inserter.func_184586_b(activeHand).func_190926_b()) {
                        return;
                    }
                    ItemStack offhandStack = inserter.func_184592_cb();
                    if (activeHand == EnumHand.OFF_HAND && !offhandStack.func_190926_b() && WorseBarrelsConfig.OFFHAND_SOFT_BLACKLIST.contains(offhandStack.func_77973_b())) {
                        return;
                    }
                }
                Object stackFinder = Iterators.singletonIterator((Object)inserter.func_184586_b(activeHand));
                if (message.insertionType == EnumItemCount.ALL) {
                    stackFinder = Iterators.concat((Iterator)stackFinder, (Iterator)Iterators.singletonIterator((Object)inserter.func_184586_b(Util.otherHand(activeHand))), (Iterator)inserter.field_71071_by.field_70462_a.iterator());
                }
                int insertedCount = 0;
                while (stackFinder.hasNext()) {
                    ItemStack toInsert = (ItemStack)stackFinder.next();
                    if (toInsert.func_190926_b()) continue;
                    if (WorseBarrelsConfig.ITEM_BLACKLIST.contains(toInsert.func_77973_b())) {
                        inserter.func_146105_b(new TextComponentTranslation("worsebarrels.cantInsertThis", new Object[]{toInsert.func_82833_r()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                        return;
                    }
                    ItemStack copy = toInsert.func_77946_l();
                    if (message.insertionType == EnumItemCount.ONE) {
                        copy.func_190920_e(1);
                    }
                    int startingCount = copy.func_190916_E();
                    ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)copy, (boolean)false);
                    int difference = startingCount - leftover.func_190916_E();
                    insertedCount += difference;
                    toInsert.func_190918_g(difference);
                }
                if (insertedCount > 150) {
                    insertedCount = 150;
                }
                float volume = Util.map(insertedCount, 0.0f, 150.0f, 0.5f, 1.0f);
                float pitch = Util.map(insertedCount, 0.0f, 150.0f, 0.8f, 1.2f);
                inserter.func_184185_a(SoundEvents.field_187638_cR, volume, pitch);
            });
            return null;
        }
    }
}

