/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import quaternary.worsebarrels.Util;
import quaternary.worsebarrels.WorseBarrels;
import quaternary.worsebarrels.etc.EnumItemCount;
import quaternary.worsebarrels.net.ByteBufUtils2;
import quaternary.worsebarrels.tile.TileWorseBarrel;

public class MessageRequestBarrelItem
implements IMessage {
    private BlockPos barrelPos;
    private EnumItemCount requestType;

    public MessageRequestBarrelItem() {
    }

    public MessageRequestBarrelItem(BlockPos barrelPos, EnumItemCount requestType) {
        this.barrelPos = barrelPos;
        this.requestType = requestType;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils2.writeBlockPos(buf, this.barrelPos);
        ByteBufUtils2.writeEnum(buf, this.requestType);
    }

    public void fromBytes(ByteBuf buf) {
        this.barrelPos = ByteBufUtils2.readBlockPos(buf);
        this.requestType = ByteBufUtils2.readEnum(buf, EnumItemCount.class);
    }

    public static class Handler
    implements IMessageHandler<MessageRequestBarrelItem, IMessage> {
        public IMessage onMessage(MessageRequestBarrelItem message, MessageContext ctx) {
            EntityPlayerMP requester = ctx.getServerHandler().field_147369_b;
            WorldServer ws = requester.func_71121_q();
            ws.func_152344_a(() -> {
                ItemStack extracted;
                double barrelDistance;
                if (message.requestType == null) {
                    Util.naughtyPlayer(ctx, "Tried to request with invalid type");
                    return;
                }
                if (!ws.func_175667_e(message.barrelPos)) {
                    Util.naughtyPlayer(ctx, "Tried to request from unloaded position");
                    return;
                }
                IAttributeInstance reachAttr = requester.func_110140_aT().func_111151_a(EntityPlayerMP.REACH_DISTANCE);
                double reachDistanceSq = reachAttr.func_111126_e() * reachAttr.func_111126_e();
                if (reachDistanceSq < (barrelDistance = message.barrelPos.func_177951_i((Vec3i)requester.func_180425_c())) + 1.0) {
                    WorseBarrels.LOGGER.info("Received out-of-range barrel request packet from " + ctx.getServerHandler().field_147369_b.func_70005_c_(), (Object)", this could be evidence of some sort of cheat mod, a bug on my end... or just lag x)");
                    return;
                }
                TileEntity tile = ws.func_175625_s(message.barrelPos);
                if (!(tile instanceof TileWorseBarrel)) {
                    return;
                }
                TileWorseBarrel barrel = (TileWorseBarrel)tile;
                IItemHandler handler = (IItemHandler)barrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (handler == null) {
                    return;
                }
                switch (message.requestType) {
                    case ONE: {
                        extracted = Util.extractItem(handler, 1, false);
                        break;
                    }
                    case STACK: {
                        ItemStack sampleStack = Util.extractItem(handler, 1, true);
                        extracted = Util.extractItem(handler, sampleStack.func_77976_d(), false);
                        break;
                    }
                    case ALL: {
                        extracted = Util.extractItem(handler, Integer.MAX_VALUE, false);
                        break;
                    }
                    default: {
                        extracted = null;
                    }
                }
                if (!extracted.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)requester, (ItemStack)extracted, (int)requester.field_71071_by.field_70461_c);
                }
            });
            return null;
        }
    }
}

