/*
 * Decompiled with CFR 0.152.
 */
package quaternary.worsebarrels.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import quaternary.worsebarrels.Util;
import quaternary.worsebarrels.WorseBarrels;
import quaternary.worsebarrels.WorseBarrelsConfig;
import quaternary.worsebarrels.block.BlockWorseBarrel;
import quaternary.worsebarrels.tile.TileWorseBarrel;

public class BarrelItemHandler
extends ItemStackHandler {
    private final TileWorseBarrel tile;
    public static final int STACK_COUNT = 8;
    public static final String STACK_KEY = "BarrelItem";
    public static final String COUNT_KEY = "BarrelCount";

    public BarrelItemHandler(TileWorseBarrel tile) {
        super(8);
        this.tile = tile;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack insertionStack, boolean simulate) {
        if (insertionStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (WorseBarrelsConfig.ITEM_BLACKLIST.contains(insertionStack.func_77973_b())) {
            return insertionStack;
        }
        ItemStack firstStack = this.getFirstNonemptyStack();
        boolean ok = firstStack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)firstStack, (ItemStack)insertionStack);
        if (ok &= this.getNestedBarrelDepth(insertionStack) <= WorseBarrelsConfig.MAX_NESTING_DEPTH) {
            return super.insertItem(slot, insertionStack, simulate);
        }
        return insertionStack;
    }

    protected void onContentsChanged(int slot) {
        this.tile.func_70296_d();
    }

    private int getNestedBarrelDepth(ItemStack stack_) {
        ItemStack stack = stack_;
        int depth = 0;
        while (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockWorseBarrel) {
            NBTTagCompound innerContents;
            NBTTagCompound innerNBT;
            ++depth;
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("BlockEntityTag") || !(innerNBT = stack.func_77978_p().func_74775_l("BlockEntityTag")).func_74764_b("Contents") || !(innerContents = innerNBT.func_74775_l("Contents")).func_74764_b(STACK_KEY)) break;
            NBTTagCompound innerItemNBT = innerContents.func_74775_l(STACK_KEY);
            stack = new ItemStack(innerItemNBT);
        }
        return depth;
    }

    private ItemStack getFirstNonemptyStack() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private int getItemCount() {
        int runningCount = 0;
        for (ItemStack stack : this.stacks) {
            runningCount += stack.func_190916_E();
        }
        return runningCount;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound cmp = new NBTTagCompound();
        ItemStack firstStack = Util.withStackSize(this.getFirstNonemptyStack(), 1);
        int count = this.getItemCount();
        NBTTagCompound item = new NBTTagCompound();
        firstStack.func_77955_b(item);
        cmp.func_74782_a(STACK_KEY, (NBTBase)item);
        cmp.func_74768_a(COUNT_KEY, count);
        return cmp;
    }

    public void readNBT(NBTTagCompound cmp) {
        Util.clearHandler((IItemHandlerModifiable)this);
        int count = cmp.func_74762_e(COUNT_KEY);
        if (count != 0) {
            ItemStack stack = new ItemStack(cmp.func_74775_l(STACK_KEY));
            stack.func_190920_e(count);
            ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack, (boolean)false);
            if (this.getItemCount() == 0) {
                WorseBarrels.LOGGER.fatal("Tried to load a barrel that said it was non-empty, but no items were loaded??");
                WorseBarrels.LOGGER.fatal("Tag: " + cmp.toString());
            }
        }
    }
}

