/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomes;

public class GenLayerTFStream
extends GenLayer {
    public GenLayerTFStream(long l, GenLayer genlayer) {
        super(l);
        this.field_75909_a = genlayer;
    }

    public int[] func_75904_a(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.field_75909_a.func_75904_a(nx, nz, nwidth, ndepth);
        int[] output = IntCache.func_76445_a((int)(width * depth));
        int stream = Biome.func_185362_a((Biome)TFBiomes.stream);
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int mid = input[dx + 1 + (dz + 1) * nwidth];
                int left = input[dx + 0 + (dz + 1) * nwidth];
                int down = input[dx + 1 + (dz + 0) * nwidth];
                int right = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.shouldStream(mid, left, down, right, up) ? stream : -1;
            }
        }
        return output;
    }

    boolean shouldStream(int mid, int left, int down, int right, int up) {
        if (this.shouldStream(mid, left)) {
            return true;
        }
        if (this.shouldStream(mid, right)) {
            return true;
        }
        if (this.shouldStream(mid, down)) {
            return true;
        }
        return this.shouldStream(mid, up);
    }

    boolean shouldStream(int id1, int id2) {
        if (id1 == id2) {
            return false;
        }
        if (id1 == -id2) {
            return false;
        }
        Biome biome1 = Biome.func_185357_a((int)id1);
        Biome biome2 = Biome.func_185357_a((int)id2);
        if (biome1 == TFBiomes.glacier && biome2 == TFBiomes.snowy_forest) {
            return false;
        }
        if (biome1 == TFBiomes.snowy_forest && biome2 == TFBiomes.glacier) {
            return false;
        }
        if (biome1 == TFBiomes.deepMushrooms && biome2 == TFBiomes.mushrooms) {
            return false;
        }
        if (biome1 == TFBiomes.mushrooms && biome2 == TFBiomes.deepMushrooms) {
            return false;
        }
        if (biome1 == TFBiomes.tfSwamp && biome2 == TFBiomes.fireSwamp) {
            return false;
        }
        if (biome1 == TFBiomes.fireSwamp && biome2 == TFBiomes.tfSwamp) {
            return false;
        }
        if (biome1 == TFBiomes.highlands && biome2 == TFBiomes.highlandsCenter) {
            return false;
        }
        if (biome1 == TFBiomes.highlandsCenter && biome2 == TFBiomes.highlands) {
            return false;
        }
        if (biome1 == TFBiomes.darkForest && biome2 == TFBiomes.darkForestCenter) {
            return false;
        }
        if (biome1 == TFBiomes.darkForestCenter && biome2 == TFBiomes.darkForest) {
            return false;
        }
        if (biome1 == TFBiomes.tfLake || biome2 == TFBiomes.tfLake) {
            return false;
        }
        if (biome1 == TFBiomes.clearing || biome2 == TFBiomes.oakSavanna) {
            return false;
        }
        if (biome1 == TFBiomes.oakSavanna || biome2 == TFBiomes.clearing) {
            return false;
        }
        return biome1 != TFBiomes.thornlands && biome2 != TFBiomes.thornlands;
    }
}

