/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.asm.hook;

import java.nio.FloatBuffer;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.asm.EntityCullingClassTransformer;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.renderer.entity.EntityRenderer;
import meldexun.entityculling.renderer.entity.EntityRendererOptifine;
import meldexun.entityculling.renderer.tileentity.TileEntityRenderer;
import meldexun.entityculling.renderer.tileentity.TileEntityRendererOptifine;
import meldexun.entityculling.util.culling.CullingInstance;
import meldexun.entityculling.util.matrix.Matrix4f;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public final class RenderGlobalHook {
    public static EntityRenderer entityRenderer = EntityCullingClassTransformer.OPTIFINE_DETECTED ? new EntityRendererOptifine() : new EntityRenderer();
    public static TileEntityRenderer tileEntityRenderer = EntityCullingClassTransformer.OPTIFINE_DETECTED ? new TileEntityRendererOptifine() : new TileEntityRenderer();
    private static final ReflectionField<Boolean> IS_SHADOW_PASS = new ReflectionField("net.optifine.shaders.Shaders", "isShadowPass", "isShadowPass");
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    private static int lastFrameUpdated = -1;
    private static int lastFrameUpdatedShadows = -1;
    public static double cameraEntityX;
    public static double cameraEntityY;
    public static double cameraEntityZ;

    public static void setup(double partialTicks, ICamera frustum, int frame) {
        if (EntityCullingClassTransformer.OPTIFINE_DETECTED && IS_SHADOW_PASS.getBoolean(null)) {
            if (EntityCulling.frame <= lastFrameUpdatedShadows) {
                return;
            }
            lastFrameUpdatedShadows = EntityCulling.frame;
        } else {
            if (EntityCulling.frame <= lastFrameUpdated) {
                return;
            }
            lastFrameUpdated = EntityCulling.frame;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        cameraEntityX = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
        cameraEntityY = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
        cameraEntityZ = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
        entityRenderer.setup(frustum, cameraEntityX, cameraEntityY, cameraEntityZ, partialTicks);
        tileEntityRenderer.setup(frustum, cameraEntityX, cameraEntityY, cameraEntityZ, partialTicks);
    }

    public static boolean renderEntities(float partialTicks) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        if (!(!EntityCulling.useOpenGlBasedCulling() || MinecraftForgeClient.getRenderPass() != 0 || EntityCullingClassTransformer.OPTIFINE_DETECTED && IS_SHADOW_PASS.getBoolean(null))) {
            Matrix4f matrix = RenderGlobalHook.getMatrix(2983);
            matrix.multiply(RenderGlobalHook.getMatrix(2982));
            CullingInstance.getInstance().updateResults(matrix);
        }
        entityRenderer.renderEntities(partialTicks);
        return true;
    }

    private static Matrix4f getMatrix(int matrix) {
        GL11.glGetFloat((int)matrix, (FloatBuffer)MATRIX_BUFFER);
        Matrix4f m = new Matrix4f();
        m.load(MATRIX_BUFFER);
        return m;
    }

    public static boolean renderTileEntities(float partialTicks) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        tileEntityRenderer.renderTileEntities(partialTicks);
        return true;
    }

    public static boolean shouldRenderChunkShadow(RenderGlobal.ContainerLocalRenderInformation containerLocalRenderInformation) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsDistanceLimited) {
            return true;
        }
        RenderChunk renderChunk = containerLocalRenderInformation.field_178036_a;
        BlockPos pos = renderChunk.func_178568_j();
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        float partialTicks = mc.func_184121_ak();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        if (Math.abs((double)pos.func_177958_n() + 8.0 - x) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0) {
            return false;
        }
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks + (double)entity.func_70047_e();
        if (Math.abs((double)pos.func_177956_o() + 8.0 - y) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxVerticalDistance * 16.0) {
            return false;
        }
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return Math.abs((double)pos.func_177952_p() + 8.0 - z) <= EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0;
    }
}

