/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.config;

import meldexun.entityculling.config.ResourceLocationMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.config.Config;

@Config(modid="entityculling")
public class EntityCullingConfig {
    @Config.RequiresMcRestart
    @Config.Comment(value={"Ideally should be set to equal the render distance. Ram usage (in Bytes) = 1063 * (2x + 1) ^ 3"})
    public static int cacheSize = 12;
    public static boolean debugCullInfo = false;
    public static boolean debugRenderBoxes = false;
    public static boolean disabledInSpectator = true;
    @Config.RequiresWorldRestart
    @Config.Comment(value={"Disable all changes from this mod (This is not equal to removing the mod!)."})
    public static boolean enabled = true;
    @Config.Comment(value={"If you have a weak CPU enabling this option might help reducing the CPU usage."})
    public static boolean enableRaytraceCache = false;
    @Config.Comment(value={"If enabled and OpenGl 4.4 is supported OpenGl based culling is used which is a lot faster and more accurate. If you have a weak GPU you might want to disable this."})
    public static boolean openglBasedCulling = true;
    @Config.Comment(value={"If you feel the need to increase this value because of entities being culled falsely then another modder probably messed up their render bounding boxes and you should report the issue to them. Alternatively you can use the (tile-)entityBoundingBoxGrowthList settings to fix bounding boxes on your own."})
    @Config.RangeDouble(min=0.0, max=1024.0)
    public static double raytraceThreshold = 1.0;
    @Config.Comment(value={"If enabled tile entity bounding boxes are increased slightly to avoid issues when other mods don't correctly set their bounding boxes (requires opengl based culling). If you still have culling or flickering issues you can use the 'debugRenderBoxes', 'entityBoundingBoxGrowthList' and 'tileEntityBoundingBoxGrowthList' config options to try to fix the bounding box of that entity or tile entity."})
    public static boolean tileEntityAABBGrowth = true;
    @Config.Comment(value={"Most tile entities have static bounding boxes and thus they can be cached. Tile entities whose bounding boxes are likely to change every frame or so should be added to the blacklist. Tile entities whose bounding only change every once in a while should be covered by cache updates (update speed adjustable through tileEntityCachedBoundingBoxUpdateInterval)"})
    public static boolean tileEntityCachedBoundingBoxEnabled = true;
    @Config.Comment(value={"Every frame there is a 1 in x chance to update the cached bounding box. Higher = better performance, Lower = tile entities with dynamic bounding boxes get updated faster."})
    @Config.RangeInt(min=1, max=1000000)
    public static int tileEntityCachedBoundingBoxUpdateInterval = 100;
    @Config.Comment(value={"Tile entities whose bounding boxes won't be cached (Accepts 'modid' or 'modid:tileentity')."})
    public static String[] tileEntityCachedBoundingBoxBlacklist = new String[0];
    @Config.Ignore
    public static ResourceLocationMap<TileEntity, Boolean> tileEntityCachedBoundingBoxBlacklistImpl = new ResourceLocationMap(arg_0 -> ((RegistryNamespaced)TileEntity.field_190562_f).func_177774_c(arg_0), false, s -> true);
    public static EntityOptions entity = new EntityOptions();
    public static TileEntityOptions tileEntity = new TileEntityOptions();
    public static OptifineShaderOptions optifineShaderOptions = new OptifineShaderOptions();

    private EntityCullingConfig() {
    }

    public static void onConfigChanged() {
        tileEntityCachedBoundingBoxBlacklistImpl.load(tileEntityCachedBoundingBoxBlacklist);
        EntityCullingConfig.entity.entityBoundingBoxGrowthListImpl.load(EntityCullingConfig.entity.entityBoundingBoxGrowthList);
        EntityCullingConfig.tileEntity.tileEntityBoundingBoxGrowthListImpl.load(EntityCullingConfig.tileEntity.tileEntityBoundingBoxGrowthList);
        EntityCullingConfig.entity.skipHiddenEntityRenderingBlacklistImpl.load(EntityCullingConfig.entity.skipHiddenEntityRenderingBlacklist);
        EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingBlacklistImpl.load(EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingBlacklist);
    }

    public static class OptifineShaderOptions {
        public boolean entityShadowsCulling = true;
        public boolean entityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double entityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean entityShadowsEnabled = true;
        public boolean entityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double entityShadowsMaxDistance = 4.0;
        public boolean terrainShadowsEnabled = true;
        public boolean terrainShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double terrainShadowsMaxHorizontalDistance = 8.0;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double terrainShadowsMaxVerticalDistance = 4.0;
        public boolean tileEntityShadowsCulling = true;
        public boolean tileEntityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double tileEntityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean tileEntityShadowsEnabled = true;
        public boolean tileEntityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double tileEntityShadowsMaxDistance = 4.0;
    }

    public static class TileEntityOptions {
        @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). This might cause issues where a tile entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
        public boolean skipHiddenTileEntityRendering = true;
        @Config.Comment(value={"Tile entities with a width or height greater than this value will always get rendered."})
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double skipHiddenTileEntityRenderingSize = 16.0;
        @Config.Comment(value={"Tile entities which will always be rendered. (Accepts 'modid' or 'modid:tile_entity_name')"})
        public String[] skipHiddenTileEntityRenderingBlacklist = new String[0];
        @Config.Ignore
        public ResourceLocationMap<TileEntity, Boolean> skipHiddenTileEntityRenderingBlacklistImpl = new ResourceLocationMap(arg_0 -> ((RegistryNamespaced)TileEntity.field_190562_f).func_177774_c(arg_0), false, s -> true);
        @Config.Comment(value={"Allows you to increase the render bounding boxes of tile entities (or all entities of a mod). Width increases the size on the X and Z axis. Top increases the size in the positive Y direction. Bottom increases the size in the negative Y direction. (Accepts 'modid=width,top,bottom' or 'modid:tileentity=width,top,bottom')."})
        public String[] tileEntityBoundingBoxGrowthList = new String[0];
        @Config.Ignore
        public ResourceLocationMap<TileEntity, Vec3d> tileEntityBoundingBoxGrowthListImpl = new ResourceLocationMap(arg_0 -> ((RegistryNamespaced)TileEntity.field_190562_f).func_177774_c(arg_0), null, s -> {
            double x = ((String[])s).length >= 1 ? Double.parseDouble(s[0]) : 0.0;
            double y = ((String[])s).length >= 2 ? Double.parseDouble(s[1]) : 0.0;
            double z = ((String[])s).length >= 3 ? Double.parseDouble(s[2]) : 0.0;
            return x != 0.0 || y != 0.0 || z != 0.0 ? new Vec3d(x, y, z) : null;
        });
    }

    public static class EntityOptions {
        public boolean alwaysRenderBosses = true;
        public boolean alwaysRenderEntitiesWithName = true;
        public boolean alwaysRenderPlayers = true;
        public boolean alwaysRenderViewEntity = true;
        @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). This might cause issues where an entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
        public boolean skipHiddenEntityRendering = true;
        @Config.Comment(value={"Entities with a width or height greater than this value will always get rendered."})
        @Config.RangeDouble(min=0.0, max=1024.0)
        public double skipHiddenEntityRenderingSize = 16.0;
        @Config.Comment(value={"Tile entities which will always be rendered. (Accepts 'modid' or 'modid:entity_name')"})
        public String[] skipHiddenEntityRenderingBlacklist = new String[0];
        @Config.Ignore
        public ResourceLocationMap<Entity, Boolean> skipHiddenEntityRenderingBlacklistImpl = new ResourceLocationMap(EntityList::func_191306_a, false, s -> true);
        @Config.Comment(value={"Allows you to increase the render bounding boxes of entities (or all entities of a mod). Width increases the size on the X and Z axis. Top increases the size in the positive Y direction. Bottom increases the size in the negative Y direction. (Accepts 'modid=width,top,bottom' or 'modid:entity=width,top,bottom')."})
        public String[] entityBoundingBoxGrowthList = new String[0];
        @Config.Ignore
        public ResourceLocationMap<Entity, Vec3d> entityBoundingBoxGrowthListImpl = new ResourceLocationMap(EntityList::func_191306_a, null, s -> {
            double x = ((String[])s).length >= 1 ? Double.parseDouble(s[0]) : 0.0;
            double y = ((String[])s).length >= 2 ? Double.parseDouble(s[1]) : 0.0;
            double z = ((String[])s).length >= 3 ? Double.parseDouble(s[2]) : 0.0;
            return x != 0.0 || y != 0.0 || z != 0.0 ? new Vec3d(x, y, z) : null;
        });
    }
}

