/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationMap<K, V> {
    private final Map<String, V> namespace2valueMap = new HashMap<String, V>();
    private final Map<String, V> resourceLocation2valueMap = new HashMap<String, V>();
    private final Map<Class<? extends K>, V> class2valueMap = new HashMap<Class<? extends K>, V>();
    private final Function<Class<K>, ResourceLocation> resourceLocationFunc;
    private final V defaultValue;
    private final Function<String[], V> valueParser;

    public ResourceLocationMap(Function<Class<K>, ResourceLocation> func, V defaultValue, Function<String[], V> valueParser) {
        this.resourceLocationFunc = func;
        this.defaultValue = defaultValue;
        this.valueParser = valueParser;
    }

    public V get(K t) {
        if (this.namespace2valueMap.isEmpty() && this.resourceLocation2valueMap.isEmpty()) {
            return this.defaultValue;
        }
        return (V)this.class2valueMap.computeIfAbsent(t.getClass(), k -> {
            ResourceLocation resourceLocation = this.resourceLocationFunc.apply((Class<K>)k);
            if (resourceLocation == null) {
                return this.defaultValue;
            }
            V value = this.resourceLocation2valueMap.get(resourceLocation.toString());
            if (value != null) {
                return value;
            }
            value = this.namespace2valueMap.get(resourceLocation.func_110624_b());
            if (value != null) {
                return value;
            }
            return this.defaultValue;
        });
    }

    public void load(String[] data) {
        this.namespace2valueMap.clear();
        this.resourceLocation2valueMap.clear();
        this.class2valueMap.clear();
        for (String entry : data) {
            int indexKeyDelimiter = entry.indexOf(58);
            int indexEntryDelimiter = entry.indexOf(61);
            String key = indexEntryDelimiter != -1 ? entry.substring(0, indexEntryDelimiter) : entry;
            String[] rawValue = indexEntryDelimiter != -1 ? (String[])Arrays.stream(entry.substring(indexEntryDelimiter + 1).split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new) : new String[]{};
            V value = this.valueParser.apply(rawValue);
            if (value == null) continue;
            if (indexKeyDelimiter == -1 || indexEntryDelimiter != -1 && indexKeyDelimiter > indexKeyDelimiter) {
                this.namespace2valueMap.put(key, value);
                continue;
            }
            this.resourceLocation2valueMap.put(key, value);
        }
    }
}

