/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.mixin;

import java.util.Random;
import javax.annotation.Nullable;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.integration.ValkyrienSkies;
import meldexun.entityculling.util.IBoundingBoxCache;
import meldexun.entityculling.util.ITileEntityRendererCache;
import meldexun.entityculling.util.MutableAABB;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TileEntity.class})
public class MixinTileEntity
implements IBoundingBoxCache,
ITileEntityRendererCache {
    @Unique
    private static final Random RAND = new Random(){
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private long seed = 0L;

        @Override
        public void setSeed(long seed) {
            this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        @Override
        protected int next(int bits) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(this.seed >>> 48 - bits);
        }
    };
    @Unique
    private final MutableAABB cachedBoundingBox = new MutableAABB();
    @Unique
    private boolean initialized;
    @Unique
    private TileEntitySpecialRenderer<TileEntity> renderer;
    @Unique
    private boolean rendererInitialized;

    @Override
    @Unique
    public void updateCachedBoundingBox(double partialTicks) {
        if (!this.initialized || !EntityCullingConfig.tileEntityCachedBoundingBoxEnabled || EntityCullingConfig.tileEntityCachedBoundingBoxBlacklistImpl.get((TileEntity)this).booleanValue() || EntityCullingConfig.tileEntityCachedBoundingBoxUpdateInterval == 1 || RAND.nextInt(EntityCullingConfig.tileEntityCachedBoundingBoxUpdateInterval) == 0) {
            this.cachedBoundingBox.set(EntityCulling.isValkyrienSkiesInstalled ? ValkyrienSkies.getAABB((TileEntity)this) : ((TileEntity)this).getRenderBoundingBox());
            Vec3d v = EntityCullingConfig.tileEntity.tileEntityBoundingBoxGrowthListImpl.get((TileEntity)this);
            if (v != null) {
                this.cachedBoundingBox.grow(v);
            }
            if (EntityCulling.useOpenGlBasedCulling() && EntityCullingConfig.tileEntityAABBGrowth) {
                this.cachedBoundingBox.grow(0.03125);
            }
            this.initialized = true;
        }
    }

    @Override
    @Unique
    public MutableAABB getCachedBoundingBox() {
        return this.cachedBoundingBox;
    }

    @Override
    @Unique
    @Nullable
    public <T extends TileEntity> TileEntitySpecialRenderer<T> getRenderer() {
        if (!this.rendererInitialized) {
            this.renderer = this.loadRenderer((TileEntity)this);
            this.rendererInitialized = true;
        }
        return this.renderer;
    }
}

