/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.renderer.entity;

import java.util.ArrayDeque;
import java.util.Queue;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.renderer.entity.EntityRenderer;
import meldexun.entityculling.util.ICullable;
import meldexun.reflectionutil.ReflectionField;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.MinecraftForgeClient;

public class EntityRendererOptifine
extends EntityRenderer {
    private static final ReflectionMethod<Boolean> IS_SHADERS = new ReflectionMethod("Config", "isShaders", "isShaders", new Class[0]);
    private static final ReflectionField<Boolean> IS_SHADOW_PASS = new ReflectionField("net.optifine.shaders.Shaders", "isShadowPass", "isShadowPass");
    private static final ReflectionMethod<Boolean> NEXT_ENTITY = new ReflectionMethod("net.optifine.shaders.Shaders", "nextEntity", "nextEntity", Entity.class);
    private static final ReflectionField<Entity> RENDERED_ENTITY = new ReflectionField(RenderGlobal.class, "renderedEntity", "renderedEntity");
    private static final ReflectionMethod<Boolean> IS_FAST_RENDER = new ReflectionMethod("Config", "isFastRender", "isFastRender", new Class[0]);
    private static final ReflectionMethod<Boolean> IS_ANTIALIASING = new ReflectionMethod("Config", "isAntialiasing", "isAntialiasing", new Class[0]);
    private static final ReflectionMethod<Void> BEGIN_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "beginEntitiesGlowing", "beginEntitiesGlowing", new Class[0]);
    private static final ReflectionMethod<Void> END_ENTITIES_GLOWING = new ReflectionMethod("net.optifine.shaders.Shaders", "endEntitiesGlowing", "endEntitiesGlowing", new Class[0]);
    protected final Queue<Entity> entityListOutlinePass1 = new ArrayDeque<Entity>();
    private boolean isShaders = false;

    @Override
    public void setup(ICamera camera, double camX, double camY, double camZ, double partialTicks) {
        this.isShaders = IS_SHADERS.invoke(null, new Object[0]);
        super.setup(camera, camX, camY, camZ, partialTicks);
    }

    @Override
    protected void clearEntityLists() {
        super.clearEntityLists();
        this.entityListOutlinePass1.clear();
    }

    @Override
    protected void fillEntityLists(ICamera camera, double camX, double camY, double camZ, double partialTicks) {
        if (IS_SHADOW_PASS.getBoolean(null) && !EntityCullingConfig.optifineShaderOptions.entityShadowsEnabled) {
            return;
        }
        int r = this.renderedEntities;
        int o = this.occludedEntities;
        int t = this.totalEntities;
        super.fillEntityLists(camera, camX, camY, camZ, partialTicks);
        if (IS_SHADOW_PASS.getBoolean(null)) {
            this.renderedEntities = r;
            this.occludedEntities = o;
            this.totalEntities = t;
        }
    }

    @Override
    protected <T extends Entity> boolean addToRenderLists(T entity, ICamera camera, double camX, double camY, double camZ, double partialTicks) {
        if (!super.addToRenderLists(entity, camera, camX, camY, camZ, partialTicks)) {
            return false;
        }
        if (entity.shouldRenderInPass(1) && this.shouldRenderOutlines(entity)) {
            this.entityListOutlinePass1.add(entity);
        }
        return true;
    }

    @Override
    protected boolean shouldRenderEntity(Entity entity, double camX, double camY, double camZ) {
        if (IS_SHADOW_PASS.getBoolean(null)) {
            if (EntityCullingConfig.optifineShaderOptions.entityShadowsDistanceLimited) {
                double d = EntityCullingConfig.optifineShaderOptions.entityShadowsMaxDistance * 16.0;
                if (entity.func_70092_e(camX, camY, camZ) > d * d) {
                    return false;
                }
            }
            return true;
        }
        return super.shouldRenderEntity(entity, camX, camY, camZ);
    }

    @Override
    protected boolean isOcclusionCulled(Entity entity, double partialTicks) {
        if (IS_SHADOW_PASS.getBoolean(null)) {
            return ((ICullable)entity).isShadowCulled();
        }
        return super.isOcclusionCulled(entity, partialTicks);
    }

    @Override
    public void renderEntities(float partialTicks) {
        Queue<Entity> outlineEntities;
        super.renderEntities(partialTicks);
        Minecraft mc = Minecraft.func_71410_x();
        Queue<Entity> queue = outlineEntities = MinecraftForgeClient.getRenderPass() == 0 ? this.entityListOutlinePass0 : this.entityListOutlinePass1;
        if (!(this.isRenderEntityOutlines() || outlineEntities.isEmpty() && !mc.field_71438_f.field_184386_ad)) {
            mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
            boolean bl = mc.field_71438_f.field_184386_ad = !outlineEntities.isEmpty();
            if (!outlineEntities.isEmpty()) {
                if (this.isShaders) {
                    BEGIN_ENTITIES_GLOWING.invoke(null, new Object[0]);
                }
                GlStateManager.func_179106_n();
                GlStateManager.func_179097_i();
                mc.field_71460_t.func_175072_h();
                RenderHelper.func_74518_a();
                mc.func_175598_ae().func_178632_c(true);
                for (Entity entity : outlineEntities) {
                    if (this.isShaders) {
                        NEXT_ENTITY.invoke(null, entity);
                    }
                    mc.func_175598_ae().func_188388_a(entity, mc.func_184121_ak(), false);
                }
                mc.func_175598_ae().func_178632_c(false);
                RenderHelper.func_74519_b();
                mc.field_71460_t.func_180436_i();
                GlStateManager.func_179126_j();
                GlStateManager.func_179127_m();
                if (this.isShaders) {
                    END_ENTITIES_GLOWING.invoke(null, new Object[0]);
                }
            }
        }
    }

    @Override
    protected void preRenderEntity(Entity entity) {
        if (this.isShaders) {
            NEXT_ENTITY.invoke(null, entity);
        }
        RENDERED_ENTITY.set(Minecraft.func_71410_x().field_71438_f, entity);
        super.preRenderEntity(entity);
    }

    @Override
    protected void postRenderEntity() {
        super.postRenderEntity();
        RENDERED_ENTITY.set(Minecraft.func_71410_x().field_71438_f, null);
    }

    @Override
    protected boolean isRenderEntityOutlines() {
        if (IS_FAST_RENDER.invoke(null, new Object[0]).booleanValue()) {
            return false;
        }
        if (IS_SHADERS.invoke(null, new Object[0]).booleanValue()) {
            return false;
        }
        if (IS_ANTIALIASING.invoke(null, new Object[0]).booleanValue()) {
            return false;
        }
        return super.isRenderEntityOutlines();
    }
}

