/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util.raytracing;

import java.util.function.BooleanSupplier;
import meldexun.entityculling.util.raytracing.IRaytracingCache;
import meldexun.entityculling.util.raytracing.Int2BoolMap;

class RaytracingMapCache
implements IRaytracingCache {
    private final Int2BoolMap map = new Int2BoolMap();

    RaytracingMapCache() {
    }

    @Override
    public boolean getOrSetCachedValue(int x, int y, int z, BooleanSupplier function) {
        int i = this.index(x, y, z);
        if (i < 0) {
            return function.getAsBoolean();
        }
        return this.map.computeIfAbsent(i, k -> function.getAsBoolean());
    }

    private int index(int x, int y, int z) {
        if ((x += 512) < 0 || x >= 1024) {
            return -1;
        }
        if ((y += 512) < 0 || y >= 1024) {
            return -1;
        }
        if ((z += 512) < 0 || z >= 1024) {
            return -1;
        }
        return z << 20 | y << 10 | x;
    }

    @Override
    public void clearCache() {
        this.map.clear();
    }
}

