/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.capacitor.IndexedScaler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public enum ScalerFactory implements Scaler
{
    INVALID(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return 0.0f;
        }
    }),
    IDENTITY(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return Math.max(idx, 0.0f);
        }
    }),
    LINEAR_0_8(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return MathHelper.func_76131_a((float)idx, (float)0.0f, (float)8.0f);
        }
    }),
    QUADRATIC(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return (float)Math.pow(2.0, idx - 1.0f);
        }
    }),
    QUADRATIC_1_8(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return (float)MathHelper.func_151237_a((double)Math.pow(2.0, idx - 1.0f), (double)1.0, (double)8.0);
        }
    }),
    CUBIC(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return (float)Math.pow(3.0, idx - 1.0f);
        }
    }),
    OCTADIC_1_8(new IndexedScaler(0.5f, 0.0f, 0.5f, 1.0f, 3.0f, 2.0f, 4.0f, 8.0f, 10.0f, 16.0f)),
    POWER(new IndexedScaler(1.0f, 0.0f, 1.0f, 3.0f, 5.0f, 8.0f, 13.0f, 18.0f)),
    CHARGE(new IndexedScaler(1.0f, 1000.0f, 100.0f, 60.0f, 20.0f, 10.0f, 1.0f)),
    SPEED(new IndexedScaler(1.0f, 100.0f, 20.0f, 10.0f, 2.0f, 1.0f)),
    POWER10(new IndexedScaler(1.0f, 0.0f, 1.0f, 2.0f, 10.0f, 20.0f, 40.0f)),
    RANGE(new IndexedScaler(1.0f, 0.0f, 4.0f, 6.0f, 10.0f, 17.0f, 24.0f)),
    FIXED(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return 1.0f;
        }
    }),
    SPAWNER(new IndexedScaler(1.0f, 0.0f, 1.0f, 5.0f, 10.0f, 20.0f, 40.0f)),
    BURNTIME(new IndexedScaler(1.0f, new float[]{0.8f, 1.0f, 1.25f, 1.5f, 1.5f, 2.0f, 2.5f}){

        @Override
        public float scaleValue(float idx) {
            return super.scaleValue(idx) / 100.0f;
        }
    }),
    CHEMICAL(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return 1.0f + (idx - 1.0f) * 0.25f;
        }
    }),
    DROPOFF(new IndexedScaler(1.0f, 1.0f, 1.0f, 1.3333334f, 2.0f, 2.5f, 3.0f, 3.25f)),
    CENT(new Scaler(){

        @Override
        public float scaleValue(float idx) {
            return 0.01f;
        }
    });

    @Nonnull
    private final Scaler scaler;

    private ScalerFactory(Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    public float scaleValue(float idx) {
        return this.scaler.scaleValue(idx);
    }

    @Nullable
    public static String toString(@Nonnull Scaler scaler) {
        if (scaler instanceof ScalerFactory) {
            return ((ScalerFactory)scaler).name();
        }
        if (scaler instanceof IndexedScaler) {
            return ((IndexedScaler)scaler).store();
        }
        return null;
    }

    @Nullable
    public static Scaler fromString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("idx(")) {
            s = s.replace('(', ':').replace(')', ':').replaceAll("::", ":");
        }
        if (s.startsWith("idx:")) {
            try {
                String[] split = s.split(":");
                float scale = 0.0f;
                float[] values = new float[split.length - 2];
                int i = -2;
                for (String sub : split) {
                    if (i >= -1) {
                        Float value = Float.valueOf(sub);
                        if (i == -1) {
                            scale = value.floatValue();
                        } else {
                            values[i] = value.floatValue();
                        }
                    }
                    ++i;
                }
                return new IndexedScaler(scale, values);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            return ScalerFactory.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }
}

