/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.IndexedScaler;
import crazypants.enderio.base.config.recipes.xml.Scaler;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;

public class Capacitor
extends AbstractConditional {
    private Optional<ResourceLocation> key = this.empty();
    private boolean required;
    private boolean disabled;
    private int base = Integer.MIN_VALUE;
    private Optional<Scaler> scaler = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.disabled) {
            return this;
        }
        try {
            super.readResolve();
            if (!this.scaler.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <scaler> or <indexed>");
            }
            if (this.base == Integer.MIN_VALUE) {
                throw new InvalidRecipeConfigException("'base' is invalid");
            }
            if (this.key.isPresent()) {
                this.valid = CapacitorKeyRegistry.contains(this.get(this.key));
                if (this.required && !this.valid && this.active) {
                    throw new InvalidRecipeConfigException("'key' is invalid");
                }
            } else {
                throw new InvalidRecipeConfigException("'key' is invalid");
            }
            boolean bl = this.valid = this.valid && this.scaler.get().isValid();
            if (this.required && !this.valid && this.active) {
                throw new InvalidRecipeConfigException("No valid <scaler> or <indexed>");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <capacitor>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.disabled || !this.active) {
            return;
        }
        this.scaler.get().enforceValidity();
        if (!this.key.isPresent() || !CapacitorKeyRegistry.contains(this.key.get())) {
            throw new InvalidRecipeConfigException("'key' '" + this.key.get() + "' is invalid");
        }
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
        if (!this.disabled && this.valid && this.active) {
            Log.debug("Registering XML recipe '" + this.getName() + "'");
            CapacitorKeyRegistry.setValue(this.key.get(), this.base, this.scaler.get().getScaler(), this.scaler.get().getScalerString());
        } else {
            Log.debug("Skipping XML recipe '" + this.getName() + "' (valid=" + this.valid + ", active=" + this.active + ", required=" + this.required + ", disabled=" + this.disabled + ")");
        }
    }

    @Override
    @Nonnull
    public String getName() {
        if (this.key.isPresent()) {
            return this.key.get().toString();
        }
        return "unnamed recipe";
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("key".equals(name)) {
            this.key = this.of(new ResourceLocation((String)NullHelper.first((Object[])new String[]{value, ""})));
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        if ("base".equals(name)) {
            this.base = Integer.parseInt(value);
            return true;
        }
        if ("scaler".equals(name) && !this.scaler.isPresent()) {
            this.scaler = this.of(new Scaler(value).readResolve());
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("scaler".equals(name) && !this.scaler.isPresent()) {
            this.scaler = this.of(factory.read(new Scaler(), startElement));
            return true;
        }
        if ("indexed".equals(name) && !this.scaler.isPresent()) {
            this.scaler = this.of(factory.read(new IndexedScaler(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public boolean isValid() {
        return this.disabled || super.isValid();
    }

    @Override
    public boolean isActive() {
        return !this.disabled && super.isActive();
    }
}

