/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Recipe
implements IRecipe {
    @Nonnull
    private final IRecipeInput[] inputs;
    @Nonnull
    private final RecipeOutput[] outputs;
    private final int energyRequired;
    @Nonnull
    private final RecipeBonusType bonusType;
    @Nonnull
    private final RecipeLevel recipeLevel;

    public Recipe(RecipeOutput output, int energyRequired, @Nonnull RecipeBonusType bonusType, @Nonnull RecipeLevel recipeLevel, IRecipeInput ... input) {
        this(input, new RecipeOutput[]{output}, energyRequired, bonusType, recipeLevel);
    }

    public Recipe(IRecipeInput input, int energyRequired, @Nonnull RecipeBonusType bonusType, @Nonnull RecipeLevel recipeLevel, RecipeOutput ... output) {
        this(new IRecipeInput[]{input}, output, energyRequired, bonusType, recipeLevel);
    }

    public Recipe(@Nonnull IRecipeInput[] input, @Nonnull RecipeOutput[] output, int energyRequired, @Nonnull RecipeBonusType bonusType, @Nonnull RecipeLevel recipeLevel) {
        this.inputs = input;
        this.outputs = output;
        this.energyRequired = energyRequired;
        this.bonusType = bonusType;
        this.recipeLevel = recipeLevel;
    }

    @Override
    public boolean isInputForRecipe(NNList<MachineRecipeInput> machineInputs) {
        IRecipeInput required;
        if (machineInputs == null || machineInputs.size() == 0) {
            return false;
        }
        for (MachineRecipeInput realInput : machineInputs) {
            if (realInput == null || realInput.fluid == null && !Prep.isValid(realInput.item) || this.isAnyInput(realInput)) continue;
            return false;
        }
        ArrayList<IRecipeInput> requiredInputs = new ArrayList<IRecipeInput>();
        for (IRecipeInput input : this.inputs) {
            if (!input.isValid()) continue;
            requiredInputs.add(input.copy());
        }
        for (MachineRecipeInput input : machineInputs) {
            if (input == null || !input.isFluid()) continue;
            Iterator iterator = requiredInputs.iterator();
            while (iterator != null && iterator.hasNext()) {
                required = (IRecipeInput)iterator.next();
                if (!required.isInput(input.fluid)) continue;
                required.getFluidInput().amount -= input.fluid.amount;
                if (required.getFluidInput().amount <= 0) {
                    iterator.remove();
                }
                iterator = null;
            }
            if (iterator == null) continue;
            return false;
        }
        for (MachineRecipeInput input : machineInputs) {
            if (input == null || input.isFluid()) continue;
            Iterator iterator = requiredInputs.iterator();
            while (iterator != null && iterator.hasNext()) {
                required = (IRecipeInput)iterator.next();
                if (!required.isInput(input.item)) continue;
                required.shrinkStack(input.item.func_190916_E());
                if (required.getStackSize() <= 0) {
                    iterator.remove();
                }
                iterator = null;
            }
            if (iterator == null) continue;
            return false;
        }
        return requiredInputs.isEmpty();
    }

    private boolean isAnyInput(@Nonnull MachineRecipeInput realInput) {
        for (IRecipeInput recipeInput : this.inputs) {
            if (recipeInput == null || !recipeInput.isInput(realInput.item) && !recipeInput.isInput(realInput.fluid)) continue;
            return true;
        }
        return false;
    }

    protected int getMinNumInputs() {
        return this.inputs.length;
    }

    @Override
    public boolean isValidInput(int slot, @Nonnull ItemStack item) {
        return this.getInputForStack(item) != null;
    }

    @Override
    public boolean isValidInput(@Nonnull FluidStack fluid) {
        return this.getInputForStack(fluid) != null;
    }

    private IRecipeInput getInputForStack(@Nonnull FluidStack input) {
        for (IRecipeInput ri : this.inputs) {
            if (!ri.isInput(input)) continue;
            return ri;
        }
        return null;
    }

    private IRecipeInput getInputForStack(@Nonnull ItemStack input) {
        for (IRecipeInput ri : this.inputs) {
            if (!ri.isInput(input)) continue;
            return ri;
        }
        return null;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getInputStacks() {
        NNList res = new NNList();
        for (int i = 0; i < this.inputs.length; ++i) {
            int slotNumber;
            IRecipeInput in = this.inputs[i];
            if (in == null || in.isFluid()) continue;
            int n = slotNumber = in.getSlotNumber() >= 0 ? in.getSlotNumber() : i;
            while (res.size() <= slotNumber) {
                res.add((Object)Prep.getEmpty());
            }
            ItemStack input = in.getInput();
            if (!Prep.isValid(input)) continue;
            res.set(slotNumber, (Object)input);
        }
        return res;
    }

    @Override
    @Nonnull
    public NNList<List<ItemStack>> getInputStackAlternatives() {
        NNList res = new NNList();
        for (int i = 0; i < this.inputs.length; ++i) {
            int slotNumber;
            IRecipeInput in = this.inputs[i];
            if (in == null || in.isFluid()) continue;
            int n = slotNumber = in.getSlotNumber() >= 0 ? in.getSlotNumber() : i;
            while (res.size() <= slotNumber) {
                res.add((Object)new NNList());
            }
            Object[] equivelentInputs = in.getEquivelentInputs();
            if (equivelentInputs != null && equivelentInputs.length != 0) {
                ((NNList)res.get(slotNumber)).addAll(equivelentInputs);
                continue;
            }
            ItemStack input = in.getInput();
            if (!Prep.isValid(input)) continue;
            ((NNList)res.get(slotNumber)).add((Object)input);
        }
        return res;
    }

    @Override
    public NNList<FluidStack> getInputFluidStacks() {
        NNList res = new NNList();
        for (int i = 0; i < this.inputs.length; ++i) {
            IRecipeInput in = this.inputs[i];
            if (in == null || in.getFluidInput() == null) continue;
            res.add((Object)in.getFluidInput());
        }
        return res;
    }

    @Override
    @Nonnull
    public IRecipeInput[] getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public RecipeOutput[] getOutputs() {
        return this.outputs;
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType() {
        return this.bonusType;
    }

    public boolean hasOuput(@Nonnull ItemStack result) {
        if (Prep.isInvalid(result)) {
            return false;
        }
        for (RecipeOutput output : this.outputs) {
            ItemStack os = output.getOutput();
            if (!os.func_77969_a(result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public boolean isValid() {
        if (this.energyRequired <= 0) {
            return false;
        }
        for (IRecipeInput input : this.inputs) {
            if (input.isValid()) continue;
            return false;
        }
        for (RecipeOutput output : this.outputs) {
            if (output.isValid()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Recipe [input=" + Arrays.toString(this.inputs) + ", output=" + Arrays.toString(this.outputs) + ", energyRequired=" + this.energyRequired + "]";
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    @Nonnull
    public RecipeLevel getRecipeLevel() {
        return this.recipeLevel;
    }
}

