/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.transceiver;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class ChannelRegister {
    protected SetMultimap<ChannelType, Channel> channels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
    private long generation = 0L;

    public Set<Channel> getChannelsForType(ChannelType type) {
        return Collections.unmodifiableSet(this.channels.get((Object)type));
    }

    public Collection<Channel> getAllChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    public void addChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        this.channels.put((Object)channel.getType(), (Object)channel);
        this.generation = MinecraftServer.func_130071_aq();
    }

    public void removeChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        this.channels.get((Object)channel.getType()).remove(channel);
        this.generation = MinecraftServer.func_130071_aq();
    }

    public void reset() {
        this.channels.clear();
        this.generation = 0L;
    }

    protected long getGeneration() {
        return this.generation;
    }

    protected void setGeneration(long generation) {
        this.generation = generation;
    }
}

