/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.redstone;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.filter.redstone.IInputSignalFilter;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    @Nonnull
    private final BundledSignal bundledSignal = new BundledSignal();
    int updatingNetwork = 0;
    private int baseId = 0;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class, IRedstoneConduit.class);
    }

    @Override
    public void init(@Nonnull IConduitBundle tile, Collection<IRedstoneConduit> connections, @Nonnull World world) throws ConduitUtil.UnloadedBlockException {
        super.init(tile, connections, world);
        ++this.updatingNetwork;
        this.notifyNeigborsOfSignalUpdate();
        --this.updatingNetwork;
    }

    @Override
    public void destroyNetwork() {
        ++this.updatingNetwork;
        for (IRedstoneConduit con : this.getConduits()) {
            con.setActive(false);
        }
        this.bundledSignal.clear();
        this.notifyNeigborsOfSignalUpdate();
        --this.updatingNetwork;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(@Nonnull IRedstoneConduit con) {
        super.addConduit(con);
        con.setSignalIdBase(this.baseId);
        this.baseId += 6;
        this.updateInputsFromConduit(con, true);
    }

    public void updateInputsFromConduit(@Nonnull IRedstoneConduit con, boolean delayUpdate) {
        ++this.updatingNetwork;
        this.notifyConduitNeighbours(con);
        --this.updatingNetwork;
        for (EnumFacing side : EnumFacing.values()) {
            if (side == null || !con.getConnectionMode(side).acceptsOutput()) continue;
            this.updateInputsForSource(con, side);
        }
        if (!delayUpdate) {
            this.notifyNeigborsOfSignalUpdate();
        }
        if (((Boolean)ConduitConfig.showState.get()).booleanValue()) {
            this.updateActiveState();
        }
    }

    private void updateActiveState() {
        boolean isActive = false;
        for (CombinedSignal s : this.bundledSignal.getSignals()) {
            if (s.getStrength() <= 0) continue;
            isActive = true;
            break;
        }
        for (IRedstoneConduit con : this.getConduits()) {
            con.setActive(isActive);
        }
    }

    private void updateInputsForSource(@Nonnull IRedstoneConduit con, @Nonnull EnumFacing dir) {
        ++this.updatingNetwork;
        Signal signal = con.getNetworkInput(dir);
        this.bundledSignal.addSignal(con.getInputSignalColor(dir), signal);
        --this.updatingNetwork;
    }

    @Nonnull
    public BundledSignal getBundledSignal() {
        return this.bundledSignal;
    }

    void setNetworkEnabled(boolean enabled) {
        this.updatingNetwork += enabled ? -1 : 1;
    }

    public boolean isNetworkEnabled() {
        return this.updatingNetwork == 0;
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.getConduits()) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<").append(te.func_174877_v().func_177958_n()).append(",").append(te.func_174877_v().func_177956_o()).append(",").append(te.func_174877_v().func_177952_p()).append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (CombinedSignal s : this.bundledSignal.getSignals()) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignalUpdate() {
        for (IRedstoneConduit con : new ArrayList(this.getConduits())) {
            this.notifyConduitNeighbours(con);
        }
    }

    private void notifyConduitNeighbours(@Nonnull IRedstoneConduit con) {
        BlockPos bc1;
        TileEntity te = con.getBundle().getEntity();
        World world = te.func_145831_w();
        if (!world.func_175667_e(bc1 = te.func_174877_v())) {
            return;
        }
        EnumSet<EnumFacing> cons = EnumSet.copyOf(con.getExternalConnections());
        if (!this.neighborNotifyEvent(world, bc1, null, cons)) {
            for (EnumFacing dir : con.getExternalConnections()) {
                BlockPos bc2 = bc1.func_177972_a((EnumFacing)NullHelper.notnull((Object)dir, (String)"Conduit external connections contains null"));
                if (!world.func_175667_e(bc2)) continue;
                world.func_190524_a(bc2, ConduitRegistry.getConduitModObjectNN().getBlockNN(), bc1);
                IBlockState bs = world.func_180495_p(bc2);
                if (!bs.func_185898_k() || this.neighborNotifyEvent(world, bc2, bs, EnumSet.allOf(EnumFacing.class))) continue;
                NNList.NNIterator itr = NNList.FACING.fastIterator();
                while (itr.hasNext()) {
                    EnumFacing dir2 = (EnumFacing)itr.next();
                    BlockPos bc3 = bc2.func_177972_a(dir2);
                    if (bc3.equals((Object)bc1) || !world.func_175667_e(bc3)) continue;
                    world.func_190524_a(bc3, ConduitRegistry.getConduitModObjectNN().getBlockNN(), bc1);
                }
            }
        }
    }

    private boolean neighborNotifyEvent(World world, @Nonnull BlockPos pos, @Nullable IBlockState state, EnumSet<EnumFacing> dirs) {
        return ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)(state == null ? world.func_180495_p(pos) : state), dirs, (boolean)false).isCanceled();
    }

    @Override
    public void tickEnd(@Nullable Profiler profiler) {
        Prof.start(profiler, "checkTickingFilters");
        String oldSignals = null;
        block0: for (IRedstoneConduit con : this.getConduits()) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == null || !((IInputSignalFilter)con.getSignalFilter(dir, false)).shouldUpdate()) continue;
                if (oldSignals == null) {
                    oldSignals = this.signalsString();
                }
                this.updateInputsFromConduit(con, true);
                continue block0;
            }
        }
        if (oldSignals != null && !oldSignals.equals(this.signalsString())) {
            Prof.next(profiler, "notifyNeighborsForTickingFilters");
            this.notifyNeigborsOfSignalUpdate();
        }
        Prof.stop(profiler);
    }
}

