/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.base.filter.fluid.FluidFilter;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFluidFilter
extends AbstractConduitPacket.Sided<ILiquidConduit> {
    private boolean isInput;
    @Nonnull
    private IFluidFilter filter = new FluidFilter();

    public PacketFluidFilter() {
    }

    public PacketFluidFilter(@Nonnull EnderLiquidConduit eConduit, @Nonnull EnumFacing dir, @Nonnull IFluidFilter filter, boolean isInput) {
        super(eConduit, dir);
        this.filter = filter;
        this.isInput = isInput;
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.isInput);
        NBTTagCompound tag = new NBTTagCompound();
        this.filter.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.isInput = buf.readBoolean();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null) {
            this.filter.readFromNBT(tag);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketFluidFilter, IMessage> {
        public IMessage onMessage(PacketFluidFilter message, MessageContext ctx) {
            ILiquidConduit conduit = (ILiquidConduit)message.getConduit(ctx);
            if (!(conduit instanceof EnderLiquidConduit)) {
                return null;
            }
            EnderLiquidConduit eCon = (EnderLiquidConduit)conduit;
            eCon.setFilter(message.dir, message.filter, message.isInput);
            IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
            message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            return null;
        }
    }
}

