/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.server;

import com.enderio.core.common.network.CompressedDataInput;
import com.enderio.core.common.network.CompressedDataOutput;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.invpanel.capability.IDatabaseHandler;
import crazypants.enderio.base.invpanel.capability.InventoryDatabaseSource;
import crazypants.enderio.base.invpanel.database.AbstractInventory;
import crazypants.enderio.base.invpanel.database.IChangeLog;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IInventoryPanel;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.util.CompositeList;
import crazypants.enderio.invpanel.config.InvpanelConfig;
import crazypants.enderio.invpanel.database.InventoryDatabase;
import crazypants.enderio.invpanel.network.PacketDatabaseReset;
import crazypants.enderio.invpanel.server.ChangeLogList;
import crazypants.enderio.invpanel.server.InventoryFactory;
import crazypants.enderio.invpanel.server.ItemEntry;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InventoryDatabaseServer
extends InventoryDatabase<IServerItemEntry>
implements IInventoryDatabaseServer {
    private static final AtomicInteger nextGeneration = new AtomicInteger((int)(Math.random() * 1000.0));
    private final IDatabaseHandler[] dbHandlers;
    private final int[] networkChangeCounts;
    private AbstractInventory[] inventories;
    private int currentInventory;
    private IChangeLog changeLog;
    private boolean sentToClient;
    private int tickPause;

    public InventoryDatabaseServer(IDatabaseHandler ... dbHandlers) {
        this.dbHandlers = dbHandlers;
        this.networkChangeCounts = new int[dbHandlers.length];
    }

    @Override
    public boolean isCurrent() {
        for (int i = 0; i < this.dbHandlers.length; ++i) {
            if (this.networkChangeCounts[i] == this.dbHandlers[i].getChangeCount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addChangeLog(IChangeLog cl) {
        if (this.changeLog == null) {
            this.changeLog = cl;
        } else if (this.changeLog instanceof ChangeLogList) {
            ((ChangeLogList)this.changeLog).add(cl);
        } else if (this.changeLog != cl) {
            this.changeLog = new ChangeLogList(this.changeLog, cl);
        }
    }

    @Override
    public void removeChangeLog(IChangeLog cl) {
        if (this.changeLog == cl) {
            this.changeLog = null;
        } else if (this.changeLog instanceof ChangeLogList) {
            this.changeLog = ((ChangeLogList)this.changeLog).remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IServerItemEntry> decompressMissingItems(byte[] compressed) throws IOException {
        try (CompressedDataInput cdi = new CompressedDataInput(compressed);){
            int pktGeneration = cdi.readVariable();
            if (pktGeneration != this.generation) {
                List<IServerItemEntry> list = Collections.emptyList();
                return list;
            }
            int numIDs = cdi.readVariable();
            ArrayList<IServerItemEntry> items = new ArrayList<IServerItemEntry>(numIDs);
            for (int i = 0; i < numIDs; ++i) {
                int dbIndex = cdi.readVariable();
                if (dbIndex >= this.complexItems.size()) continue;
                IServerItemEntry entry = (IServerItemEntry)this.complexItems.get(dbIndex);
                items.add(entry);
            }
            ArrayList<IServerItemEntry> arrayList = items;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compressItemInfo(List<? extends IServerItemEntry> items) throws IOException {
        try (CompressedDataOutput cdo = new CompressedDataOutput();){
            int count = items.size();
            cdo.writeVariable(count);
            for (IServerItemEntry iServerItemEntry : items) {
                assert (iServerItemEntry.getDbID() >= 65536);
                int code = iServerItemEntry.getDbID() - 65536 << 1;
                if (iServerItemEntry.getNbt() != null) {
                    code |= 1;
                }
                cdo.writeVariable(code);
                cdo.writeVariable(iServerItemEntry.getItemID());
                cdo.writeVariable(iServerItemEntry.getMeta());
                if (iServerItemEntry.getNbt() != null) {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)iServerItemEntry.getNbt(), (DataOutput)cdo);
                }
                cdo.writeVariable(iServerItemEntry.countItems());
            }
            Object object = cdo.getCompressed();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compressItemList() throws IOException {
        try (CompressedDataOutput cdo = new CompressedDataOutput();){
            cdo.writeByte(0);
            for (Map.Entry entry : this.simpleRegsitry.entrySet()) {
                int count = ((IServerItemEntry)entry.getValue()).countItems();
                if (count <= 0) continue;
                cdo.writeVariable(count);
                cdo.writeShort(((Integer)entry.getKey()).intValue());
            }
            cdo.writeByte(0);
            int prevID = 65536;
            for (IServerItemEntry entry : this.complexItems) {
                int count;
                if (entry == null || (count = entry.countItems()) <= 0) continue;
                cdo.writeVariable(count);
                cdo.writeVariable(entry.getDbID() - prevID);
                prevID = entry.getDbID();
            }
            cdo.writeByte(0);
            this.sentToClient = true;
            Object object = cdo.getCompressed();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compressChangedItems(Collection<? extends IServerItemEntry> items) throws IOException {
        try (CompressedDataOutput cdo = new CompressedDataOutput();){
            cdo.writeVariable(items.size());
            for (IServerItemEntry iServerItemEntry : items) {
                cdo.writeVariable(iServerItemEntry.getDbID());
                cdo.writeVariable(iServerItemEntry.countItems());
            }
            Object object = cdo.getCompressed();
            return object;
        }
    }

    @Override
    public void resetDatabase() {
        this.simpleRegsitry.clear();
        this.complexRegistry.clear();
        this.complexItems.clear();
        this.currentInventory = 0;
        if (this.sentToClient) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketDatabaseReset(this.generation));
            this.sentToClient = false;
        }
    }

    @Override
    public void updateNetworkSources() {
        int i;
        this.resetDatabase();
        this.generation = nextGeneration.incrementAndGet();
        List<InventoryDatabaseSource> sources = null;
        for (i = 0; i < this.dbHandlers.length; ++i) {
            this.networkChangeCounts[i] = this.dbHandlers[i].getChangeCount();
            sources = CompositeList.create(sources, this.dbHandlers[i].getSources());
        }
        if (sources == null || sources.isEmpty()) {
            this.inventories = null;
        } else {
            this.inventories = new AbstractInventory[sources.size()];
            for (i = 0; i < sources.size(); ++i) {
                InventoryDatabaseSource inv = sources.get(i);
                this.inventories[i] = InventoryFactory.createInventory(inv);
            }
        }
        if (this.changeLog != null) {
            this.changeLog.databaseReset();
        }
    }

    @Override
    public int getNumInventories() {
        return this.inventories == null ? 0 : this.inventories.length;
    }

    @Override
    public boolean isOperational(IInventoryPanel te) {
        return te.getPowerLevel() > 0.0f && this.inventories != null;
    }

    @Override
    public int extractItems(IServerItemEntry entry, int count, @Nonnull IInventoryPanel te) {
        float availablePower = te.getPowerLevel() + te.getAvailablePower();
        if ((availablePower -= ((Float)InvpanelConfig.inventoryPanelExtractCostPerOperation.get()).floatValue()) <= 0.0f) {
            return 0;
        }
        if (((Float)InvpanelConfig.inventoryPanelExtractCostPerOperation.get()).floatValue() > 0.0f) {
            long maxCount = Math.round(Math.floor(availablePower / ((Float)InvpanelConfig.inventoryPanelExtractCostPerOperation.get()).floatValue()));
            count = (int)Math.min(maxCount, (long)count);
        }
        if (count > 0) {
            int extracted = entry.extractItems(this, count);
            te.usePower(((Float)InvpanelConfig.inventoryPanelExtractCostPerOperation.get()).floatValue() + (float)extracted * ((Float)InvpanelConfig.inventoryPanelExtractCostPerOperation.get()).floatValue());
            te.refuelPower(this);
            return extracted;
        }
        return 0;
    }

    private void scanNextInventory(IInventoryPanel te) {
        if (!this.isOperational(te)) {
            this.tickPause = 20;
            return;
        }
        int currentInventoryIn = this.currentInventory;
        long now = EnderIO.proxy.getServerTickCount();
        do {
            AbstractInventory inv = this.inventories[this.currentInventory];
            this.currentInventory = (this.currentInventory + 1) % this.inventories.length;
            if (!inv.shouldBeScannedNow(now)) continue;
            int slots = inv.scanInventory(this);
            inv.markScanned();
            this.tickPause += Math.min(1 + (slots + 8) / 9, 20);
            te.usePower((float)slots * ((Float)InvpanelConfig.inventoryPanelScanCostPerSlot.get()).floatValue());
            return;
        } while (currentInventoryIn != this.currentInventory);
        this.tickPause += 10;
    }

    @Override
    public void tick(IInventoryPanel te) {
        if (--this.tickPause <= 0) {
            this.scanNextInventory(te);
        }
    }

    @Override
    public void entryChanged(IServerItemEntry entry) {
        if (this.changeLog != null) {
            this.changeLog.entryChanged(entry);
        }
    }

    @Override
    public void sendChangeLogs() {
        if (this.changeLog != null) {
            this.changeLog.sendChangeLog();
        }
    }

    @Override
    protected IServerItemEntry createItemEntry(int dbId, int hash, int itemID, int meta, NBTTagCompound nbt) {
        return new ItemEntry(dbId, hash, itemID, meta, nbt);
    }

    AbstractInventory getInventory(int aiIndex) {
        return this.inventories[aiIndex];
    }

    @Override
    public void onNeighborChange(@Nonnull BlockPos neighborPos) {
        if (this.inventories == null) {
            return;
        }
        for (AbstractInventory abstractInventory : this.inventories) {
            abstractInventory.markForScanning(neighborPos);
        }
    }
}

