/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.google.common.collect.Lists;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.machines.EnderIOMachines;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum VoidMode {
    ALWAYS,
    IF_NOT_CONTAINER,
    NEVER;


    @SideOnly(value=Side.CLIENT)
    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        ALWAYS_ICON(ALWAYS, IconEIO.TICK),
        IF_NOT_CONTAINER_ICON(IF_NOT_CONTAINER, IconEIO.ITEM_SINGLE),
        NEVER_ICON(NEVER, IconEIO.CROSS);

        @Nonnull
        private final VoidMode mode;
        @Nonnull
        private final IWidgetIcon icon;
        @Nonnull
        private final List<String> unlocTooltips;

        private IconHolder(VoidMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
            String prefix = "gui.tank.void.mode";
            String str = prefix + "." + this.name().replace("_ICON", "").toLowerCase(Locale.US);
            this.unlocTooltips = Lists.newArrayList((Object[])new String[]{prefix, str, str + ".desc"});
        }

        @Nonnull
        public IWidgetIcon getIcon() {
            return this.icon;
        }

        @Nonnull
        public List<String> getTooltipLines() {
            return EnderIOMachines.lang.localizeAll(this.unlocTooltips);
        }

        @Nonnull
        public VoidMode getMode() {
            return this.mode;
        }

        @Nonnull
        public static IconHolder getFromMode(@Nonnull VoidMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return NEVER_ICON;
        }
    }
}

