/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkState;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderiopowertools", value={Side.CLIENT})
public class ClientNetworkManager {
    @Nonnull
    private static final ClientNetworkManager instance = new ClientNetworkManager();
    @Nonnull
    private final Map<Integer, WeakReference<CapBankClientNetwork>> networks = new HashMap<Integer, WeakReference<CapBankClientNetwork>>();

    @Nonnull
    public static ClientNetworkManager getInstance() {
        return instance;
    }

    ClientNetworkManager() {
    }

    public void destroyNetwork(int id) {
        CapBankClientNetwork res;
        WeakReference<CapBankClientNetwork> ref = this.networks.remove(id);
        if (ref != null && (res = (CapBankClientNetwork)ref.get()) != null) {
            res.destroyNetwork();
        }
    }

    public void updateState(int id, @Nonnull NetworkState state) {
        CapBankClientNetwork network = this.getOrCreateNetwork(id);
        network.setState(state);
    }

    public void updateEnergy(int id, long energyStored, float avgInput, float avgOutput) {
        WeakReference<CapBankClientNetwork> ref = this.networks.get(id);
        if (ref == null) {
            return;
        }
        CapBankClientNetwork res = (CapBankClientNetwork)ref.get();
        if (res == null) {
            return;
        }
        res.setEnergyStored(energyStored);
        res.setAverageIOPerTick(avgInput, avgOutput);
    }

    @Nonnull
    public CapBankClientNetwork getOrCreateNetwork(int id) {
        CapBankClientNetwork res;
        WeakReference<CapBankClientNetwork> ref = this.networks.get(id);
        CapBankClientNetwork capBankClientNetwork = res = ref != null ? (CapBankClientNetwork)ref.get() : null;
        if (res == null) {
            res = new CapBankClientNetwork(id);
            this.networks.put(id, new WeakReference<CapBankClientNetwork>(res));
        }
        return res;
    }

    public void addToNetwork(int id, @Nonnull TileCapBank tileCapBank) {
        CapBankClientNetwork network = this.getOrCreateNetwork(id);
        network.addMember(tileCapBank);
    }

    @SubscribeEvent
    public static void unload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldClient) {
            ClientNetworkManager.instance.networks.clear();
        }
    }
}

