/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class Profiler {
    public static final Profiler instance = new Profiler(false);
    private ConcurrentHashMap<String, Data> profiler = new ConcurrentHashMap();
    private long lastProfiled = 0L;
    private final boolean on;

    public Profiler(boolean on) {
        this.on = on;
    }

    public long start() {
        return this.on ? System.nanoTime() : Long.MAX_VALUE;
    }

    public long pause(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public long resume(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public void stop(long start, String source) {
        long elapsed;
        long l = elapsed = this.on ? System.nanoTime() - start : -1L;
        if (elapsed >= 0L) {
            try {
                this.profiler.putIfAbsent(source, new Data());
                Data data = this.profiler.get(source);
                data.time += elapsed;
                ++data.count;
                if (EnderIO.proxy.getTickCount() > this.lastProfiled) {
                    this.lastProfiled = EnderIO.proxy.getTickCount() + 200L;
                    NNList keys = new NNList((Collection)this.profiler.keySet());
                    Collections.sort(keys, (a, b) -> a.compareTo((String)b));
                    for (String key : keys) {
                        Data value = this.profiler.get(key);
                        long avg = value.time / value.count;
                        Log.info(key + ": " + avg + " ns avg over " + value.count + " calls");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class Data {
        long time = 0L;
        long count = 0L;

        private Data() {
        }
    }
}

