/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.collect.ImmutableMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import slimeknights.mantle.util.RecipeMatchRegistry;

public class Util {
    public static final String MODID = "tconstruct";
    public static final String RESOURCE = "tconstruct".toLowerCase(Locale.US);
    public static final DecimalFormat df = new DecimalFormat("#,###,###.##", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat dfPercent = new DecimalFormat("#%");
    private static ImmutableMap<Vec3i, EnumFacing> offsetMap;
    private static boolean celsiusPref;

    public static Logger getLogger(String type) {
        String log = MODID;
        return LogManager.getLogger((String)(log + "-" + type));
    }

    public static String sanitizeLocalizationString(String string) {
        return string.toLowerCase(Locale.US).replaceAll(" ", "");
    }

    public static String resource(String res) {
        return String.format("%s:%s", RESOURCE, res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation(RESOURCE, res);
    }

    public static ModelResourceLocation getModelResource(String res, String variant) {
        return new ModelResourceLocation(Util.resource(res), variant);
    }

    public static ResourceLocation getModifierResource(String res) {
        return Util.getResource("models/item/modifiers/" + res);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", RESOURCE, name.toLowerCase(Locale.US));
    }

    public static String translate(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74838_a((String)String.format(key, pars)).trim()).trim();
    }

    public static String translateFormatted(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74837_a((String)key, (Object[])pars).trim()).trim();
    }

    public static NonNullList<ItemStack> deepCopyFixedNonNullList(NonNullList<ItemStack> in) {
        return RecipeMatchRegistry.copyItemStackArray(in);
    }

    @Deprecated
    public static NonNullList<ItemStack> copyItemStackArray(NonNullList<ItemStack> in) {
        return Util.deepCopyFixedNonNullList(in);
    }

    public static boolean isCtrlKeyDown() {
        boolean isCtrlKeyDown;
        boolean bl = isCtrlKeyDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (!isCtrlKeyDown && Minecraft.field_142025_a) {
            isCtrlKeyDown = Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return isCtrlKeyDown;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static int enumChatFormattingToColor(TextFormatting color) {
        int i = color.func_175746_b();
        int j = (i >> 3 & 1) * 85;
        int k = (i >> 2 & 1) * 170 + j;
        int l = (i >> 1 & 1) * 170 + j;
        int i1 = (i >> 0 & 1) * 170 + j;
        if (i == 6) {
            k += 85;
        }
        if (i >= 16) {
            k /= 4;
            l /= 4;
            i1 /= 4;
        }
        return (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
    }

    public static EnumFacing facingFromOffset(BlockPos offset) {
        return (EnumFacing)offsetMap.get((Object)offset);
    }

    public static EnumFacing facingFromNeighbor(BlockPos pos, BlockPos neighbor) {
        return Util.facingFromOffset(neighbor.func_177973_b((Vec3i)pos));
    }

    public static boolean clickedAABB(AxisAlignedBB aabb, float hitX, float hitY, float hitZ) {
        return aabb.field_72340_a <= (double)hitX && (double)hitX <= aabb.field_72336_d && aabb.field_72338_b <= (double)hitY && (double)hitY <= aabb.field_72337_e && aabb.field_72339_c <= (double)hitZ && (double)hitZ <= aabb.field_72334_f;
    }

    public static void setTemperaturePref(boolean celsius) {
        celsiusPref = celsius;
    }

    public static String temperatureString(int temperature) {
        return Util.temperatureString(temperature, celsiusPref);
    }

    public static String temperatureString(int temperature, boolean celsius) {
        if (celsius) {
            return Util.translateFormatted("gui.general.temperature.celsius", temperature - 300);
        }
        return Util.translateFormatted("gui.general.temperature.kelvin", temperature);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            builder.put((Object)facing.func_176730_m(), (Object)facing);
        }
        offsetMap = builder.build();
        celsiusPref = false;
    }
}

