/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

@SideOnly(value=Side.CLIENT)
public class RenderEvents
implements IResourceManagerReloadListener {
    private static final ResourceLocation widgetsTexPath = new ResourceLocation("textures/gui/widgets.png");
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    @SubscribeEvent
    public void renderExtraBlockBreak(RenderWorldLastEvent event) {
        double distance;
        RayTraceResult mop;
        Entity renderEntity;
        PlayerControllerMP controllerMP = Minecraft.func_71410_x().field_71442_b;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        ItemStack tool = player.func_184614_ca();
        if (!tool.func_190926_b() && (renderEntity = Minecraft.func_71410_x().func_175606_aa()) != null && (mop = renderEntity.func_174822_a(distance = (double)controllerMP.func_78757_d(), event.getPartialTicks())) != null && (tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)player, world.func_180495_p(mop.func_178782_a()))).func_77973_b() instanceof IAoeTool) {
            ImmutableList<BlockPos> extraBlocks = ((IAoeTool)tool.func_77973_b()).getAOEBlocks(tool, world, (EntityPlayer)player, mop.func_178782_a());
            for (BlockPos pos : extraBlocks) {
                event.getContext().func_72731_b((EntityPlayer)player, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), null, pos), 0, event.getPartialTicks());
            }
        }
        if (controllerMP.field_78778_j && (tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)player, world.func_180495_p(controllerMP.field_178895_c))).func_77973_b() instanceof IAoeTool && ((IAoeTool)tool.func_77973_b()).isAoeHarvestTool()) {
            BlockPos pos = controllerMP.field_178895_c;
            this.drawBlockDamageTexture(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), (Entity)player, event.getPartialTicks(), world, (List<BlockPos>)((IAoeTool)tool.func_77973_b()).getAOEBlocks(tool, world, (EntityPlayer)player, pos));
        }
    }

    public void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferBuilder, Entity entityIn, float partialTicks, World world, List<BlockPos> blocks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        int progress = (int)(Minecraft.func_71410_x().field_71442_b.field_78770_f * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilder.func_178969_c(-d0, -d1, -d2);
        bufferBuilder.func_78914_f();
        for (BlockPos blockpos : blocks) {
            IBlockState iblockstate;
            boolean hasBreak;
            double d3 = (double)blockpos.func_177958_n() - d0;
            double d4 = (double)blockpos.func_177956_o() - d1;
            double d5 = (double)blockpos.func_177952_p() - d2;
            Block block = world.func_180495_p(blockpos).func_177230_c();
            TileEntity te = world.func_175625_s(blockpos);
            boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
            if (!hasBreak) {
                boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
            }
            if (hasBreak || (iblockstate = world.func_180495_p(blockpos)).func_177230_c().func_149688_o(iblockstate) == Material.field_151579_a) continue;
            TextureAtlasSprite textureatlassprite = this.destroyBlockIcons[progress];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void handRenderEvent(RenderSpecificHandEvent event) {
        ItemStack stack;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184587_cr() && !(stack = player.func_184607_cu()).func_190926_b() && stack.func_77975_n() == EnumAction.BOW) {
            if (event.getHand() != player.func_184600_cs()) {
                event.setCanceled(true);
            }
            return;
        }
        ItemStack mainStack = player.func_184614_ca();
        RayTraceResult rt = Minecraft.func_71410_x().field_71476_x;
        if (!mainStack.func_190926_b() && rt != null && rt.field_72313_a == RayTraceResult.Type.BLOCK && DualToolHarvestUtils.shouldUseOffhand((EntityLivingBase)player, rt.func_178782_a(), mainStack)) {
            ItemStack itemStack;
            EnumHand hand;
            event.setCanceled(true);
            if (event.getHand() == EnumHand.MAIN_HAND) {
                hand = EnumHand.OFF_HAND;
                itemStack = player.func_184592_cb();
            } else {
                hand = EnumHand.MAIN_HAND;
                itemStack = player.func_184614_ca();
            }
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175597_ag();
            itemRenderer.func_187457_a((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), hand, event.getSwingProgress(), itemStack, event.getEquipProgress());
        }
    }

    @SubscribeEvent
    public void onFovEvent(FOVUpdateEvent event) {
        ItemStack stack = event.getEntity().func_184607_cu();
        if (!stack.func_190926_b()) {
            float zoom = 0.0f;
            float progress = 0.0f;
            if (stack.func_77973_b() == TinkerRangedWeapons.longBow) {
                zoom = 0.35f;
                progress = TinkerRangedWeapons.longBow.getDrawbackProgress(stack, (EntityLivingBase)event.getEntity());
            }
            if (zoom > 0.0f) {
                event.setNewfov(1.0f - progress * progress * zoom);
            }
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
            this.destroyBlockIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }
}

