/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;

public class SlimeColorizer
implements IResourceManagerReloadListener {
    public static int colorBlue = 2813057;
    public static int colorPurple = 11087359;
    public static int colorOrange = 13670400;
    private static final ResourceLocation LOC_SLIME_BLUE_PNG = Util.getResource("textures/colormap/slimegrasscolor.png");
    private static final ResourceLocation LOC_SLIME_PURPLE_PNG = Util.getResource("textures/colormap/purplegrasscolor.png");
    private static final ResourceLocation LOC_SLIME_ORANGE_PNG = Util.getResource("textures/colormap/orangegrasscolor.png");
    private static int[] colorBufferBlue = new int[65536];
    private static int[] colorBufferPurple = new int[65536];
    private static int[] colorBufferOrange = new int[65536];
    public static final float loop = 256.0f;
    public static final BlockPos LOOP_OFFSET = new BlockPos(128.0, 0.0, 128.0);

    public static int getColorBlue(int x, int z) {
        return SlimeColorizer.getColor(x, z, colorBufferBlue);
    }

    public static int getColorPurple(int x, int z) {
        return SlimeColorizer.getColor(x, z, colorBufferPurple);
    }

    public static int getColorOrange(int x, int z) {
        return SlimeColorizer.getColor(x, z, colorBufferOrange);
    }

    private static int getColor(int posX, int posZ, int[] buffer) {
        float z;
        float x = Math.abs((256.0f - (float)Math.abs(posX) % 512.0f) / 256.0f);
        if (x < (z = Math.abs((256.0f - (float)Math.abs(posZ) % 512.0f) / 256.0f))) {
            float tmp = x;
            x = z;
            z = tmp;
        }
        return buffer[(int)(x * 255.0f) << 8 | (int)(z * 255.0f)];
    }

    public static int getColorStaticBGR(BlockSlimeGrass.FoliageType type) {
        int color = SlimeColorizer.getColorStatic(type);
        return color >> 16 & 0xFF | (color & 0xFF) << 16 | color & 0xFF00;
    }

    public static int getColorStatic(BlockSlimeGrass.FoliageType type) {
        if (type == BlockSlimeGrass.FoliageType.PURPLE) {
            return colorPurple;
        }
        if (type == BlockSlimeGrass.FoliageType.ORANGE) {
            return colorOrange;
        }
        return colorBlue;
    }

    public static int getColorForPos(BlockPos pos, BlockSlimeGrass.FoliageType type) {
        if (type == BlockSlimeGrass.FoliageType.PURPLE) {
            return SlimeColorizer.getColorPurple(pos.func_177958_n(), pos.func_177952_p());
        }
        if (type == BlockSlimeGrass.FoliageType.ORANGE) {
            return SlimeColorizer.getColorOrange(pos.func_177958_n(), pos.func_177952_p());
        }
        return SlimeColorizer.getColorBlue(pos.func_177958_n(), pos.func_177952_p());
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        try {
            colorBufferBlue = TextureUtil.func_110986_a((IResourceManager)resourceManager, (ResourceLocation)LOC_SLIME_BLUE_PNG);
            colorBufferPurple = TextureUtil.func_110986_a((IResourceManager)resourceManager, (ResourceLocation)LOC_SLIME_PURPLE_PNG);
            colorBufferOrange = TextureUtil.func_110986_a((IResourceManager)resourceManager, (ResourceLocation)LOC_SLIME_ORANGE_PNG);
        }
        catch (IOException e) {
            TConstruct.log.error((Object)e);
        }
    }
}

