/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter.chests;

import com.google.common.collect.Lists;
import cubex2.mods.chesttransporter.chests.TransportableChestOld;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class VariertyChest
extends TransportableChestOld {
    private static final String[] chestTypes = new String[]{"spruce", "birch", "jungle", "acacia", "darkoak", "original"};
    private final boolean isGlow;

    public VariertyChest(Block chestBlock, int chestMeta, int transporterDV, boolean isGlow) {
        super(chestBlock, chestMeta, transporterDV, null);
        this.isGlow = isGlow;
    }

    @Override
    public ItemStack createChestStack(ItemStack transporter) {
        return new ItemStack(Item.func_150898_a((Block)this.getChestBlock()), 1, 0);
    }

    @Override
    public void preRemoveChest(World world, BlockPos pos, EntityPlayer player, ItemStack transporter) {
        try {
            TileEntity chestTE = world.func_175625_s(pos);
            Class<?> clazz = Class.forName("de.sanandrew.mods.varietychests.tileentity.TileEntityCustomChest");
            Class<?> clazz1 = Class.forName("de.sanandrew.mods.varietychests.util.ChestType");
            String chestType = ObfuscationReflectionHelper.getPrivateValue(clazz, (Object)chestTE, (String[])new String[]{"chestType"}).toString();
            clazz1.getField("name").setAccessible(true);
            Object chestName = clazz1.getDeclaredField("name").get(chestType);
            transporter.func_77978_p().func_74778_a("VCChestType", (String)chestName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onChestPlaced(World world, BlockPos pos, EntityPlayer player, ItemStack transporter) {
        try {
            TileEntity chestTE = world.func_175625_s(pos);
            Class<?> clazz = Class.forName("de.sanandrew.mods.varietychests.tileentity.TileEntityCustomChest");
            String chestType = transporter.func_77978_p().func_74779_i("VCChestType");
            ObfuscationReflectionHelper.setPrivateValue(clazz, (Object)chestTE, (Object)chestType, (String[])new String[]{"chestType"});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResourceLocation getChestModel(ItemStack stack) {
        String chestType = stack.func_77978_p().func_74779_i("VCChestType");
        String postfix = this.isGlow ? "_glow" : "";
        return VariertyChest.locationFromName("vc_" + chestType + postfix);
    }

    @Override
    public Collection<ResourceLocation> getChestModels() {
        ArrayList models = Lists.newArrayList();
        String postfix = this.isGlow ? "_glow" : "";
        for (String chestType : chestTypes) {
            models.add(VariertyChest.locationFromName("vc_" + chestType + postfix));
        }
        return models;
    }
}

