/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.biome;

import biomesoplenty.api.biome.BiomeOwner;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.biome.generation.GenerationManager;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorFlora;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.BiomeGenBase;

public class ExtendedBiomeWrapper
implements IExtendedBiome {
    public final BiomeGenBase biome;
    private GenerationManager generationManager = new GenerationManager();
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    public int beachBiomeId;

    public ExtendedBiomeWrapper(BiomeGenBase biome) {
        this.beachBiomeId = BiomeGenBase.field_76787_r.field_76756_M;
        this.biome = biome;
        this.addGenerator("roots", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.ROOT)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.beachBiomeId = conf.getInt("beachBiomeId", this.beachBiomeId);
        BOPConfig.IConfigObj confGenerators = conf.getObject("generators");
        if (confGenerators != null) {
            for (String name : confGenerators.getKeys()) {
                this.generationManager.configureWith(name, confGenerators.getObject(name));
            }
        }
    }

    @Override
    public BiomeOwner getBiomeOwner() {
        return BiomeOwner.OTHER;
    }

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        this.generationManager.addGenerator(name, stage, generator);
    }

    public IGenerator getGenerator(String name) {
        return this.generationManager.getGenerator(name);
    }

    public void removeGenerator(String name) {
        this.generationManager.removeGenerator(name);
    }

    @Override
    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    public Map<BOPClimates, Integer> getWeightMap() {
        return this.weightMap;
    }

    @Override
    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    @Override
    public void clearWeights() {
        this.weightMap.clear();
    }

    @Override
    public int getBeachId() {
        return this.beachBiomeId;
    }

    @Override
    public BiomeGenBase getBaseBiome() {
        return this.biome;
    }
}

