/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.biome.generation;

import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.util.config.BOPConfig;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;

public class GeneratorRegistry {
    private static BiMap<String, Class<? extends IGenerator>> generatorClasses = HashBiMap.create();
    private static Map<String, IGenerator.IGeneratorBuilder> generatorBuilders = new HashMap<String, IGenerator.IGeneratorBuilder>();

    public static <T extends IGenerator> void registerGenerator(String identifier, Class<T> generatorClass, IGenerator.IGeneratorBuilder<T> builder) {
        generatorClasses.put((Object)identifier, generatorClass);
        generatorBuilders.put(identifier, builder);
    }

    public static String getIdentifier(Class<? extends IGenerator> generatorClass) {
        return (String)generatorClasses.inverse().get(generatorClass);
    }

    public static Class<? extends IGenerator> getGeneratorClass(String identifier) {
        return (Class)generatorClasses.get((Object)identifier);
    }

    public static IGenerator.IGeneratorBuilder getGeneratorBuilder(String identifier) {
        return generatorBuilders.get(identifier);
    }

    public static boolean generatorExists(String identifier) {
        return generatorClasses.containsValue((Object)identifier);
    }

    public static IGenerator createGenerator(BOPConfig.IConfigObj conf) {
        GeneratorStage stage = conf.getEnum("stage", GeneratorStage.class);
        String identifier = conf.getString("type");
        if (stage == null || identifier == null) {
            return null;
        }
        IGenerator.IGeneratorBuilder builder = GeneratorRegistry.getGeneratorBuilder(identifier);
        if (builder == null) {
            conf.addMessage("No generator is registered with type name " + identifier);
            return null;
        }
        Object generator = builder.create();
        generator.setStage(stage);
        generator.configure(conf);
        return generator;
    }
}

