/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.handler;

import biomesoplenty.client.model.ModelBiomeFinder;
import biomesoplenty.client.model.ModelFlowerBasket;
import biomesoplenty.client.texture.TextureAnimationFrame;
import biomesoplenty.client.util.TextureUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.IRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelBakeHandler {
    public static final ModelResourceLocation BIOME_FINDER_LOC = new ModelResourceLocation("biomesoplenty:biome_finder", "inventory");
    public static final ModelResourceLocation FLOWER_BASKET_LOC = new ModelResourceLocation("biomesoplenty:flower_basket", "inventory");
    public static final ModelResourceLocation FLOWER_BASKET_EMPTY_LOC = new ModelResourceLocation("biomesoplenty:flower_basket_empty", "inventory");
    public static final ModelResourceLocation FLOWER_BASKET_FULL_LOC = new ModelResourceLocation("biomesoplenty:flower_basket_full", "inventory");
    public static List<String> fluidsToTextureStitch = new ArrayList<String>();
    private TextureAnimationFrame[] biomeFinderFrames;

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureMap map = event.map;
        this.biomeFinderFrames = TextureUtils.splitAnimatedTexture(map, "biomesoplenty:items/biome_finder", 12);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        TextureMap map = event.map;
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) throws IOException {
        IRegistry modelRegistry = event.modelRegistry;
        ModelLoader modelLoader = event.modelLoader;
        IModel biomeFinderModel = modelLoader.getModel((ResourceLocation)BIOME_FINDER_LOC);
        modelRegistry.func_82595_a((Object)BIOME_FINDER_LOC, (Object)new ModelBiomeFinder(biomeFinderModel, this.biomeFinderFrames));
        modelRegistry.func_82595_a((Object)FLOWER_BASKET_LOC, (Object)new ModelFlowerBasket((IBakedModel)modelRegistry.func_82594_a((Object)FLOWER_BASKET_EMPTY_LOC), (IBakedModel)modelRegistry.func_82594_a((Object)FLOWER_BASKET_FULL_LOC)));
    }
}

