/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.block.BlockBOPLilypad;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.entities.EntitySnail;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorColumns;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorSplatter;
import biomesoplenty.common.world.feature.GeneratorWaterside;
import biomesoplenty.common.world.feature.tree.GeneratorBayouTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenBayou
extends BOPBiome {
    public BiomeGenBayou() {
        this.terrainSettings.avgHeight(63.0).heightVariation(5.0, 10.0).octaves(1.0, 1.0, 1.0, 1.0, 0.0, 0.0).sidewaysNoise(0.0);
        this.func_76739_b(9154411);
        this.func_76732_a(0.85f, 0.9f);
        this.field_76759_H = 16767282;
        this.seaFloorBlock = BOPBlocks.mud.func_176223_P();
        this.canSpawnInBiome = false;
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        this.beachBiomeId = -1;
        this.addWeight(BOPClimates.HOT_SWAMP, 10);
        this.field_76755_L.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 1, 3));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySnail.class, 8, 1, 2));
        BlockQuery.IBlockPosQuery emptyGrassOrDirt = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A, this.field_76753_B).create();
        this.addGenerator("mud", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(8.0f)).maxRadius(7).with(BOPBlocks.mud.func_176223_P())).create());
        this.addGenerator("mud_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(4.0f)).replace(emptyGrassOrDirt)).with(BOPBlocks.mud.func_176223_P())).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(8.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("willow", 3, ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new GeneratorBayouTree.Builder().log(BOPWoods.WILLOW)).leaves(BOPTrees.WILLOW)).minHeight(6)).maxHeight(12)).minLeavesRadius(1).leavesGradient(2).create());
        treeGenerator.add("willow_large", 1, ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new GeneratorBayouTree.Builder().log(BOPWoods.WILLOW)).leaves(BOPTrees.WILLOW)).minHeight(10)).maxHeight(18)).minLeavesRadius(2).leavesGradient(3).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(10.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("doublegrass", 1, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.GRASS).create());
        this.addGenerator("koru", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(BOPPlants.KORU)).create());
        this.addGenerator("cattail", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(6.0f)).with(BOPPlants.CATTAIL)).create());
        this.addGenerator("double_cattail", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(8.0f)).with(BlockBOPDoublePlant.DoublePlantType.TALL_CATTAIL).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(3.0f)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("sugar_cane", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(3.0f)).generationAttempts(24).placeOn(BlockQueries.litFertileWaterside)).with(Blocks.field_150436_aH.func_176223_P())).minHeight(1).maxHeight(3).create());
        this.addGenerator("lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.5f)).with(Blocks.field_150392_bi.func_176223_P())).create());
        this.addGenerator("medium_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(BlockBOPLilypad.LilypadType.MEDIUM)).create());
        this.addGenerator("flower_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.25f)).with(BlockBOPLilypad.LilypadType.FLOWER)).create());
        this.addGenerator("small_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).with(BlockBOPLilypad.LilypadType.SMALL)).create());
        this.addGenerator("tiny_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).with(BlockBOPLilypad.LilypadType.TINY)).create());
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        this.addGenerator("flat_mushroom", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPMushroom.MushroomType.FLAT_MUSHROOM)).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("malachite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.MALACHITE)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("malachite");
        }
        if (!settings.generateBopMushrooms) {
            this.removeGenerator("toadstools");
            this.removeGenerator("flat_mushroom");
            this.removeGenerator("blue_milk_caps");
            this.removeGenerator("portobellos");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
            this.removeGenerator("flower_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(8.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("willow", 3, ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new GeneratorBayouTree.Builder().minHeight(6)).maxHeight(12)).minLeavesRadius(1).leavesGradient(2).create());
            treeGenerator.add("willow_large", 1, ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new GeneratorBayouTree.Builder().minHeight(10)).maxHeight(18)).minLeavesRadius(2).leavesGradient(3).create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 9154411;
    }

    public int func_180625_c(BlockPos pos) {
        return 11591816;
    }

    public int getFogColour(BlockPos pos) {
        return 9482133;
    }

    public float getFogDensity(BlockPos pos) {
        return 0.99f;
    }
}

