/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.entities.EntitySnail;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorColumns;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorLakes;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorWaterside;
import biomesoplenty.common.world.feature.tree.GeneratorTwigletTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenBog
extends BOPBiome {
    public BiomeGenBog() {
        this.terrainSettings.avgHeight(64.0).heightVariation(6.0, 20.0);
        this.func_76739_b(14193503);
        this.func_76732_a(0.5f, 0.9f);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        if (BOPBiomes.gravel_beach.isPresent()) {
            this.beachBiomeId = ((BiomeGenBase)BOPBiomes.gravel_beach.get()).field_76756_M;
        }
        this.addWeight(BOPClimates.COLD_SWAMP, 7);
        this.field_76755_L.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 1, 3));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySnail.class, 8, 1, 2));
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(2.5f)).waterLakeForBiome(this).create());
        this.addGenerator("poison_lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.5f)).waterLakeForBiome(this).liquid(BOPBlocks.poison).frozenLiquid((IBlockState)null).create());
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(4.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        this.addGenerator("mud", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(3.0f)).maxRadius(7).with(BOPBlocks.mud.func_176223_P())).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.5f);
        this.addGenerator("flowers", GeneratorStage.GRASS, flowerGenerator);
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(12.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("dark_oak_twiglet", 3, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).minHeight(5)).maxHeight(10)).leafChance(0.3f, 0.9f).create());
        treeGenerator.add("birch_twiglet", 1, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().log(BlockPlanks.EnumType.BIRCH)).leaves(BlockPlanks.EnumType.BIRCH)).minHeight(5)).maxHeight(10)).leafChance(0.3f, 0.9f).create());
        treeGenerator.add("bog_bush", 3, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.OAK)).generationAttempts(8)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(9.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("koru", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.KORU)).create());
        this.addGenerator("river_cane", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(1.0f)).generationAttempts(24).placeOn(BlockQueries.litFertileWaterside)).with(BlockBOPPlant.paging.getVariantState(BOPPlants.RIVERCANE))).minHeight(1).maxHeight(3).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.6f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("poison_ivy", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.POISONIVY)).create());
        this.addGenerator("cattail", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(BOPPlants.CATTAIL)).create());
        this.addGenerator("double_cattail", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(1.0f)).with(BlockBOPDoublePlant.DoublePlantType.TALL_CATTAIL).create());
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(8.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).generationAttempts(32)).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(3.0f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        this.addGenerator("flat_mushroom", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPMushroom.MushroomType.FLAT_MUSHROOM)).create());
        this.addGenerator("blue_milk_caps", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BlockBOPMushroom.MushroomType.BLUE_MILK_CAP)).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("malachite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.MALACHITE)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("malachite");
        }
        if (!settings.generatePoisonIvy) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.generateLiquidPoison) {
            this.removeGenerator("poison_lakes");
        }
        if (!settings.generateBopMushrooms) {
            this.removeGenerator("toadstools");
            this.removeGenerator("flat_mushroom");
            this.removeGenerator("blue_milk_caps");
            this.removeGenerator("portobellos");
        }
        if (!settings.generateBopSoils) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 14193503;
    }

    public int func_180625_c(BlockPos pos) {
        return 14345593;
    }
}

