/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorWaterside;
import biomesoplenty.common.world.feature.tree.GeneratorBasicTree;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorTaigaTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenBorealForest
extends BOPBiome {
    public BiomeGenBorealForest() {
        this.terrainSettings.avgHeight(70.0).heightVariation(15.0, 30.0);
        this.func_76739_b(10467185);
        this.func_76732_a(0.3f, 0.6f);
        this.addWeight(BOPClimates.BOREAL, 5);
        this.canGenerateVillages = false;
        if (BOPBiomes.gravel_beach.isPresent()) {
            this.beachBiomeId = ((BiomeGenBase)BOPBiomes.gravel_beach.get()).field_76756_M;
        }
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.addGenerator("sand", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(3.0f)).maxRadius(7).with(Blocks.field_150354_m.func_176223_P())).create());
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(6.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(20.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("small_oak", 2, new GeneratorBasicTree.Builder().create());
        treeGenerator.add("oak", 3, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(8)).maxHeight(12)).create());
        treeGenerator.add("oak_bush", 3, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().amountPerChunk(3.0f)).maxHeight(2)).create());
        treeGenerator.add("yellow_autumn", 4, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.BIRCH)).leaves(BOPTrees.YELLOW_AUTUMN)).minHeight(5)).maxHeight(8)).create());
        treeGenerator.add("spruce", 4, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().minHeight(10)).maxHeight(19)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(10.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("fern", 4, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.FERN)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.5f);
        this.addGenerator("flowers", GeneratorStage.GRASS, flowerGenerator);
        flowerGenerator.add("rose", 2, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.ROSE).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("flax", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(0.2f)).with(BlockBOPDoublePlant.DoublePlantType.FLAX).create());
        this.addGenerator("poison_ivy", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(BOPPlants.POISONIVY)).create());
        this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        this.addGenerator("amber", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.AMBER)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("amber");
        }
        if (!settings.generatePoisonIvy) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.generateFlax) {
            this.removeGenerator("flax");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(20.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("small_oak", 2, new GeneratorBasicTree.Builder().create());
            treeGenerator.add("oak", 3, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(8)).maxHeight(12)).create());
            treeGenerator.add("oak_bush", 3, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().amountPerChunk(3.0f)).maxHeight(2)).create());
            treeGenerator.add("yellow_autumn", 4, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.BIRCH)).leaves(BlockPlanks.EnumType.BIRCH)).minHeight(5)).maxHeight(8)).create());
            treeGenerator.add("spruce", 4, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().minHeight(10)).maxHeight(19)).create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 10467185;
    }

    public int func_180625_c(BlockPos pos) {
        return 13225573;
    }
}

