/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorColumns;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorTwigletTree;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenXericShrubland
extends BOPBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenXericShrubland() {
        this.terrainSettings.avgHeight(64.0).heightVariation(1.0, 5.0);
        this.func_76739_b(14863781);
        this.func_76732_a(1.5f, 0.1f);
        this.field_76752_A = Blocks.field_150354_m.func_176223_P();
        this.field_76753_B = Blocks.field_150354_m.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = true;
        this.addWeight(BOPClimates.SAVANNA, 1);
        this.field_76762_K.clear();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(5.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("brush_twiglet", 1, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().placeOn(this.field_76752_A)).minHeight(1)).maxHeight(2)).log(BlockPlanks.EnumType.ACACIA)).leaves(BlockPlanks.EnumType.ACACIA)).create());
        treeGenerator.add("brush_bush", 3, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.ACACIA)).create());
        treeGenerator.add("oak_bush", 2, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
        this.addGenerator("dunegrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(6.0f)).with(BOPPlants.DUNEGRASS)).generationAttempts(8)).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(12.0f)).with(BOPPlants.DESERTGRASS)).generationAttempts(8)).create());
        this.addGenerator("desert_sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.5f)).with(BOPPlants.DESERTSPROUTS)).generationAttempts(8)).create());
        this.addGenerator("bromeliad", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPFlowers.BROMELIAD)).generationAttempts(8)).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("tiny_cacti", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.9f)).with(BOPPlants.TINYCACTUS)).create());
        this.addGenerator("dead_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(Blocks.field_150330_I.func_176223_P())).create());
        this.addGenerator("cacti", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(1.5f)).generationAttempts(3).placeOn(this.field_76752_A)).with(Blocks.field_150434_aF.func_176223_P())).minHeight(1).maxHeight(2).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(12.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 7, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 3, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("ruby");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopSoils) {
            this.alternateTopBlock = Blocks.field_150349_c.func_176223_P();
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        if (!settings.generateBopFlowers) {
            this.removeGenerator("flowers");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
            this.removeGenerator("dunegrass");
            this.removeGenerator("desertgrass");
        }
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public int func_180627_b(BlockPos pos) {
        return 13951142;
    }

    public int func_180625_c(BlockPos pos) {
        return 13951142;
    }
}

