/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPGeneric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockBOPBiomeBlock
extends BlockBOPGeneric {
    private static List<BiomeGenBase> biomesWithEssence;

    public BlockBOPBiomeBlock() {
        super(Material.field_151592_s);
        this.func_149711_c(0.6f);
        this.func_149672_a(Block.field_149778_k);
    }

    public List<BiomeGenBase> getBiomesWithEssence() {
        if (biomesWithEssence != null) {
            return biomesWithEssence;
        }
        biomesWithEssence = new ArrayList<BiomeGenBase>();
        List<BiomeGenBase> vanillaBiomesToExclude = Arrays.asList(BiomeGenBase.field_76779_k, BiomeGenBase.field_76778_j, BiomeGenBase.field_76787_r, BiomeGenBase.field_150577_O, BiomeGenBase.field_150576_N, BiomeGenBase.field_76771_b, BiomeGenBase.field_76776_l, BiomeGenBase.field_150575_M, BiomeGenBase.field_76781_i, BiomeGenBase.field_76777_m);
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            if (biome instanceof BOPBiome) {
                if (!((BOPBiome)biome).hasBiomeEssence()) continue;
                biomesWithEssence.add(biome);
                continue;
            }
            if (vanillaBiomesToExclude.contains(biome)) continue;
            biomesWithEssence.add(biome);
        }
        return biomesWithEssence;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<BiomeGenBase> biomes = this.getBiomesWithEssence();
        int numToDrop = rand.nextInt(fortune + 2) + 1;
        int numChoices = biomes.size();
        for (int i = 0; i < numToDrop; ++i) {
            BiomeGenBase biome = biomes.get(rand.nextInt(numChoices));
            ItemStack biome_essence = new ItemStack(BOPItems.biome_essence);
            biome_essence.func_77982_d(new NBTTagCompound());
            biome_essence.func_77978_p().func_74768_a("biomeID", biome.field_76756_M);
            ret.add(biome_essence);
        }
        return ret;
    }
}

