/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.config.GameplayConfigurationHandler;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.item.ItemBOPFlower;
import biomesoplenty.common.util.block.VariantPagingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPFlower
extends BlockBOPDecoration
implements IShearable {
    public static VariantPagingHelper<BlockBOPFlower, BOPFlowers> paging = new VariantPagingHelper(16, BOPFlowers.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPFlower());
        }
    }

    protected BlockState func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockState((Block)this, new IProperty[]{this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPFlower.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))).func_176610_l();
    }

    public BlockBOPFlower() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta)));
    }

    public int func_176201_c(IBlockState state) {
        BOPFlowers flower = (BOPFlowers)((Object)state.func_177229_b(this.variantProperty));
        return paging.getIndex(flower);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        switch ((BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty))) {
            case CLOVER: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.5f, 0.015625f, pos);
                break;
            }
            case ORANGE_COSMOS: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.2f, 0.8f, pos);
                break;
            }
            case PINK_DAFFODIL: 
            case WILTED_LILY: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.2f, 0.6f, pos);
                break;
            }
            case WHITE_ANEMONE: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.2f, 0.5f, pos);
                break;
            }
            default: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.8f, pos);
            }
        }
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        switch ((BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty))) {
            case GLOWFLOWER: {
                return 9;
            }
            case ENDERLOTUS: {
                return 5;
            }
            case BURNING_BLOSSOM: {
                return 9;
            }
        }
        return super.func_149750_m();
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileentity) {
        super.func_180657_a(world, player, pos, state, tileentity);
        if (player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemShears)) {
            switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
                case DEATHBLOOM: {
                    player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 300));
                    break;
                }
                case BURNING_BLOSSOM: {
                    player.func_70015_d(5);
                    break;
                }
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case DEATHBLOOM: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 200));
                break;
            }
            case BURNING_BLOSSOM: {
                if (!(entity instanceof EntityLivingBase)) break;
                entity.func_70015_d(1);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case DEATHBLOOM: {
                if (rand.nextInt(4) != 0) {
                    world.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                if (rand.nextInt(4) != 0) break;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case BURNING_BLOSSOM: {
                if (rand.nextInt(2) == 0) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                if (rand.nextInt(4) != 0) break;
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState groundState = world.func_180495_p(pos.func_177977_b());
        Block groundBlock = groundState.func_177230_c();
        boolean onFertile = groundBlock == Blocks.field_150346_d || groundBlock == Blocks.field_150458_ak || groundBlock == BOPBlocks.farmland_0 || groundBlock == BOPBlocks.farmland_1 || groundBlock == BOPBlocks.dirt || groundBlock == Blocks.field_150349_c;
        boolean onDry = groundBlock == Blocks.field_150405_ch || groundBlock == BOPBlocks.sand || groundBlock == Blocks.field_150354_m;
        boolean onNetherrack = groundBlock == Blocks.field_150424_aL;
        boolean onStone = groundBlock == Blocks.field_150348_b;
        boolean onDriedSand = groundBlock == BOPBlocks.dried_sand;
        boolean onSpectralMoss = false;
        if (groundBlock instanceof BlockBOPGrass) {
            switch ((BlockBOPGrass.BOPGrassType)((Object)groundState.func_177229_b((IProperty)BlockBOPGrass.VARIANT))) {
                case SPECTRAL_MOSS: {
                    onSpectralMoss = true;
                    break;
                }
                case OVERGROWN_NETHERRACK: {
                    onFertile = true;
                    onNetherrack = true;
                    break;
                }
                default: {
                    onFertile = true;
                }
            }
        }
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case ENDERLOTUS: {
                return onSpectralMoss;
            }
            case BROMELIAD: {
                return onDry;
            }
            case WILTED_LILY: {
                return onDriedSand;
            }
            case BURNING_BLOSSOM: {
                return onNetherrack;
            }
            case MINERS_DELIGHT: {
                return onStone;
            }
        }
        return onFertile;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return GameplayConfigurationHandler.flowerDropsNeedShears;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        EntityPlayer player = (EntityPlayer)this.harvesters.get();
        if (GameplayConfigurationHandler.flowerDropsNeedShears && player != null) {
            boolean usingShears;
            boolean bl = usingShears = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemShears;
            if (!usingShears) {
                return;
            }
        }
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPFlowers flower = (BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (flower) {
            case BURNING_BLOSSOM: {
                return 0;
            }
        }
        return Blocks.field_150328_O.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPFlowers flower = (BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (flower) {
            case BURNING_BLOSSOM: {
                return 0;
            }
        }
        return Blocks.field_150328_O.getFireSpreadSpeed(world, pos, face);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return new ArrayList<ItemStack>();
    }
}

