/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityWasp
extends EntityFlying
implements IMob {
    public EntityWasp(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
        this.field_70765_h = new WaspMoveHelper();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIWaspRandomFly());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIWaspAttackTarget());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
    }

    public boolean func_70652_k(Entity target) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
    }

    protected String func_70639_aQ() {
        return "biomesoplenty:mob.wasp.say";
    }

    protected String func_70621_aR() {
        return "biomesoplenty:mob.wasp.hurt";
    }

    protected String func_70673_aS() {
        return "biomesoplenty:mob.wasp.hurt";
    }

    class AIWaspAttackTarget
    extends EntityAIBase {
        private EntityWasp wasp;
        private int attackTick;
        private WaspMoveTargetPos targetPos;

        public AIWaspAttackTarget() {
            this.wasp = EntityWasp.this;
            this.attackTick = 0;
            this.targetPos = new WaspMoveTargetPos();
            this.func_75248_a(2);
        }

        public boolean attackTargetExists() {
            EntityLivingBase attackTarget = this.wasp.func_70638_az();
            return attackTarget != null && attackTarget.func_70089_S();
        }

        public boolean func_75250_a() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            return this.attackTargetExists();
        }

        public boolean func_75253_b() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (!this.attackTargetExists()) {
                return false;
            }
            EntityLivingBase attackTarget = this.wasp.func_70638_az();
            this.targetPos.setTarget(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v);
            double damageRange = this.wasp.field_70130_N + attackTarget.field_70130_N;
            if (this.attackTick <= 0 && this.targetPos.dist < damageRange) {
                this.wasp.func_70652_k((Entity)attackTarget);
                this.attackTick = 16;
            }
            if (this.targetPos.isPathClear(5.0)) {
                this.wasp.func_70605_aq().func_75642_a(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v, 1.0);
            }
            return true;
        }
    }

    class AIWaspRandomFly
    extends EntityAIBase {
        private EntityWasp wasp;
        private WaspMoveTargetPos targetPos;

        public AIWaspRandomFly() {
            this.wasp = EntityWasp.this;
            this.targetPos = new WaspMoveTargetPos();
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.wasp.func_70605_aq().func_75640_a();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rand = this.wasp.func_70681_au();
            if (this.tryGoingRandomDirection(rand, 6.0)) {
                return;
            }
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            List<EnumFacing> directions = Arrays.asList(EnumFacing.values());
            Collections.shuffle(directions);
            for (EnumFacing facing : directions) {
                if (!this.tryGoingAlongAxis(rand, facing, 1.0)) continue;
                return;
            }
        }

        public boolean tryGoingRandomDirection(Random rand, double maxDistance) {
            double dirX = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            double dirY = (rand.nextDouble() * 2.0 - 1.1) * maxDistance;
            double dirZ = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoingAlongAxis(Random rand, EnumFacing facing, double maxDistance) {
            double dirX = 0.0;
            double dirY = 0.0;
            double dirZ = 0.0;
            switch (facing.func_176740_k()) {
                case X: {
                    dirX = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                case Y: {
                    dirY = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                default: {
                    dirZ = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                }
            }
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoing(double dirX, double dirY, double dirZ) {
            this.targetPos.setTarget(this.wasp.field_70165_t + dirX, this.wasp.field_70163_u + dirY, this.wasp.field_70161_v + dirZ);
            boolean result = this.targetPos.isPathClear(5.0);
            if (result) {
                this.wasp.func_70605_aq().func_75642_a(this.targetPos.posX, this.targetPos.posY, this.targetPos.posZ, 1.0);
            }
            return result;
        }
    }

    class WaspMoveHelper
    extends EntityMoveHelper {
        private EntityWasp wasp;
        private int courseChangeCooldown;
        private double closeEnough;
        private WaspMoveTargetPos targetPos;

        public WaspMoveHelper() {
            super((EntityLiving)EntityWasp.this);
            this.wasp = EntityWasp.this;
            this.courseChangeCooldown = 0;
            this.closeEnough = 0.3;
            this.targetPos = new WaspMoveTargetPos();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            super.func_75642_a(x, y, z, speedIn);
            this.targetPos.setTarget(x, y, z);
        }

        public void func_75641_c() {
            if (!this.field_75643_f) {
                return;
            }
            if (this.courseChangeCooldown-- > 0) {
                return;
            }
            this.courseChangeCooldown += this.wasp.func_70681_au().nextInt(5) + 2;
            this.targetPos.refresh();
            double acceleration = 0.1;
            this.wasp.field_70159_w += this.targetPos.aimX * acceleration;
            this.wasp.field_70181_x += this.targetPos.aimY * acceleration;
            this.wasp.field_70179_y += this.targetPos.aimZ * acceleration;
            this.wasp.field_70761_aq = this.wasp.field_70177_z = -((float)Math.atan2(this.targetPos.distX, this.targetPos.distZ)) * 180.0f / (float)Math.PI;
            if (this.wasp.func_70681_au().nextInt(5) == 0) {
                float strafeAmount = this.wasp.func_70681_au().nextFloat() * 0.4f - 0.2f;
                this.wasp.field_70159_w += (double)(strafeAmount * MathHelper.func_76134_b((float)(this.wasp.field_70177_z * (float)Math.PI / 180.0f)));
                this.wasp.field_70179_y += (double)(strafeAmount * MathHelper.func_76126_a((float)(this.wasp.field_70177_z * (float)Math.PI / 180.0f)));
            }
            if (!this.targetPos.isPathClear(5.0)) {
                this.field_75643_f = false;
            } else if (this.targetPos.dist < this.closeEnough) {
                this.field_75643_f = false;
            }
        }
    }

    class WaspMoveTargetPos {
        private EntityWasp wasp;
        public double posX;
        public double posY;
        public double posZ;
        public double distX;
        public double distY;
        public double distZ;
        public double dist;
        public double aimX;
        public double aimY;
        public double aimZ;

        public WaspMoveTargetPos() {
            this(0.0, 0.0, 0.0);
        }

        public WaspMoveTargetPos(double posX, double posY, double posZ) {
            this.wasp = EntityWasp.this;
            this.setTarget(posX, posY, posZ);
        }

        public void setTarget(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.refresh();
        }

        public void refresh() {
            this.distX = this.posX - this.wasp.field_70165_t;
            this.distY = this.posY - this.wasp.field_70163_u;
            this.distZ = this.posZ - this.wasp.field_70161_v;
            this.dist = MathHelper.func_76133_a((double)(this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ));
            if (this.dist == 0.0) {
                this.aimX = 0.0;
                this.aimY = 0.0;
                this.aimZ = 0.0;
            } else {
                this.aimX = this.distX / this.dist;
                this.aimY = this.distY / this.dist;
                this.aimZ = this.distZ / this.dist;
            }
        }

        public boolean isBoxBlocked(AxisAlignedBB box) {
            return !this.wasp.field_70170_p.func_72945_a((Entity)this.wasp, box).isEmpty();
        }

        public boolean isPathClear(double howFar) {
            howFar = Math.min(howFar, this.dist);
            AxisAlignedBB box = this.wasp.func_174813_aQ();
            for (double i = 0.5; i < howFar; i += 1.0) {
                if (!this.isBoxBlocked(box.func_72317_d(this.aimX * i, this.aimY * i, this.aimZ * i))) continue;
                return false;
            }
            return !this.isBoxBlocked(box.func_72317_d(this.aimX * howFar, this.aimY * howFar, this.aimZ * howFar));
        }
    }
}

