/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entities.projectiles;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.api.potion.BOPPotions;
import biomesoplenty.common.item.ItemDart;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityDart
extends EntityArrow {
    private int ticksInAir = 0;

    public EntityDart(World world) {
        super(world);
    }

    public EntityDart(World world, EntityLivingBase shootingEntity, float velocity) {
        super(world, shootingEntity, velocity);
    }

    public EntityDart(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void setDartType(ItemDart.DartType dartType) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)dartType.ordinal()));
    }

    public ItemDart.DartType getDartType() {
        return ItemDart.DartType.values()[this.field_70180_af.func_75683_a(16)];
    }

    public void onHitSolidBlock() {
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        int itemId = Item.func_150891_b((Item)BOPItems.dart);
        int itemMeta = this.getDartType().ordinal();
        for (int i = 0; i < 16; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, new int[]{itemId, itemMeta});
        }
        this.func_70106_y();
    }

    public void onHitEntity(Entity entityHit) {
        boolean entitySufferedHit;
        ItemDart.DartType dartType = this.getDartType();
        DamageSource damagesource = DamageSource.func_76353_a((EntityArrow)this, (Entity)(this.field_70250_c == null ? this : this.field_70250_c));
        if (dartType == ItemDart.DartType.POISONDART && entityHit instanceof EntityLivingBase) {
            ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect(BOPPotions.paralysis.field_76415_H, 100));
        }
        if (entitySufferedHit = entityHit.func_70097_a(damagesource, dartType.getDamageInflicted())) {
            if (entityHit instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entityHit;
                if (this.field_70250_c != null && entityHit != this.field_70250_c && entityHit instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                }
            }
            this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.func_70106_y();
        } else {
            this.bounceOff();
        }
    }

    public void bounceOff() {
        this.field_70159_w *= (double)-0.1f;
        this.field_70181_x *= (double)-0.1f;
        this.field_70179_y *= (double)-0.1f;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.ticksInAir = 0;
    }

    public void func_70071_h_() {
        super.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        ++this.ticksInAir;
        Vec3 currentPosision = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 futurePosition = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition blockCollision = this.field_70170_p.func_147447_a(currentPosision, futurePosition, false, true, false);
        if (blockCollision != null) {
            futurePosition = new Vec3(blockCollision.field_72307_f.field_72450_a, blockCollision.field_72307_f.field_72448_b, blockCollision.field_72307_f.field_72449_c);
        }
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        Entity closestOnTargetEntity = null;
        double distanceToClosestOnTargetEntity = Double.POSITIVE_INFINITY;
        float entityCollisionTolerance = 0.3f;
        for (Entity entity : nearbyEntities) {
            double distanceToEntity;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition entityCollision;
            if (!entity.func_70067_L() || entity == this.field_70250_c && this.ticksInAir < 5 || (entityCollision = (axisalignedbb1 = entity.func_174813_aQ().func_72314_b((double)entityCollisionTolerance, (double)entityCollisionTolerance, (double)entityCollisionTolerance)).func_72327_a(currentPosision, futurePosition)) == null) continue;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.field_71075_bZ.field_75102_a || this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) continue;
            }
            if (!((distanceToEntity = currentPosision.func_72438_d(entityCollision.field_72307_f)) < distanceToClosestOnTargetEntity)) continue;
            closestOnTargetEntity = entity;
            distanceToClosestOnTargetEntity = distanceToEntity;
        }
        if (closestOnTargetEntity != null) {
            this.onHitEntity(closestOnTargetEntity);
        } else if (blockCollision != null) {
            this.onHitSolidBlock();
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float dartSpeed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, dartSpeed) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float dragFactor = 0.99f;
        float accelerationDueToGravity = 0.05f;
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            dragFactor = 0.6f;
        }
        this.field_70159_w *= (double)dragFactor;
        this.field_70181_x *= (double)dragFactor;
        this.field_70179_y *= (double)dragFactor;
        this.field_70181_x -= (double)accelerationDueToGravity;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }
}

