/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.enums;

import biomesoplenty.common.world.layer.BOPGenLayer;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;

public enum BOPClimates {
    ICE_CAP(BiomeManager.BiomeType.ICY),
    TUNDRA(BiomeManager.BiomeType.ICY),
    BOREAL(BiomeManager.BiomeType.COOL),
    COLD_SWAMP(BiomeManager.BiomeType.COOL),
    WET_TEMPERATE(BiomeManager.BiomeType.WARM),
    DRY_TEMPERATE(BiomeManager.BiomeType.WARM),
    COOL_TEMPERATE(BiomeManager.BiomeType.COOL),
    WARM_TEMPERATE(BiomeManager.BiomeType.WARM),
    HOT_SWAMP(BiomeManager.BiomeType.WARM),
    TROPICAL(BiomeManager.BiomeType.DESERT),
    MEDITERANEAN(BiomeManager.BiomeType.WARM),
    SAVANNA(BiomeManager.BiomeType.DESERT),
    HOT_DESERT(BiomeManager.BiomeType.DESERT),
    WASTELAND(BiomeManager.BiomeType.DESERT);

    public final BiomeManager.BiomeType biomeType;
    private int totalLandBiomesWeight;
    private ArrayList<WeightedBiomeEntry> landBiomes = new ArrayList();
    private static BOPClimates[] values;
    private static final BOPClimates[] climateMapping;

    private BOPClimates(BiomeManager.BiomeType biomeType) {
        this.biomeType = biomeType;
    }

    public BOPClimates addLandBiome(int weight, BiomeGenBase biome) {
        return this.addLandBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addLandBiome(WeightedBiomeEntry biomeEntry) {
        this.totalLandBiomesWeight += biomeEntry.weight;
        this.landBiomes.add(biomeEntry);
        return this;
    }

    public BiomeGenBase getRandomLandBiome(BOPGenLayer layer) {
        WeightedBiomeEntry item;
        int weight = layer.func_75902_a(this.totalLandBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.landBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public BiomeGenBase getRandomOceanBiome(BOPGenLayer layer, boolean deep) {
        switch (this) {
            case ICE_CAP: {
                return layer.func_75902_a(2) == 0 ? this.getRandomLandBiome(layer) : BiomeGenBase.field_76776_l;
            }
            case TUNDRA: 
            case BOREAL: {
                return layer.func_75902_a(3) != 0 ? (deep ? BiomeGenBase.field_150575_M : BiomeGenBase.field_76771_b) : BiomeGenBase.field_76776_l;
            }
        }
        return deep ? BiomeGenBase.field_150575_M : BiomeGenBase.field_76771_b;
    }

    public static BOPClimates lookup(int i) {
        return values[i];
    }

    public static int[] getClimateMappingInts() {
        int[] out = new int[108];
        for (int i = 0; i < 108; ++i) {
            out[i] = climateMapping[i].ordinal();
        }
        return out;
    }

    public static void printWeights() {
        for (BOPClimates climate : BOPClimates.values()) {
            for (WeightedBiomeEntry entry : climate.landBiomes) {
                System.out.println(climate.name() + " " + entry.biome.field_76791_y + " " + entry.weight);
            }
        }
    }

    static {
        ICE_CAP.addLandBiome(10, BiomeGenBase.field_76774_n);
        TUNDRA.addLandBiome(10, BiomeGenBase.field_150584_S).addLandBiome(10, BiomeGenBase.field_76770_e);
        BOREAL.addLandBiome(5, BiomeGenBase.field_150578_U).addLandBiome(5, BiomeGenBase.field_76770_e).addLandBiome(20, BiomeGenBase.field_76768_g);
        COLD_SWAMP.addLandBiome(5, BiomeGenBase.field_76780_h);
        WET_TEMPERATE.addLandBiome(20, BiomeGenBase.field_150585_R).addLandBiome(5, BiomeGenBase.field_76767_f);
        DRY_TEMPERATE.addLandBiome(5, BiomeGenBase.field_76772_c);
        COOL_TEMPERATE.addLandBiome(15, BiomeGenBase.field_76767_f).addLandBiome(10, BiomeGenBase.field_150583_P);
        WARM_TEMPERATE.addLandBiome(20, BiomeGenBase.field_76772_c).addLandBiome(5, BiomeGenBase.field_150583_P);
        HOT_SWAMP.addLandBiome(5, BiomeGenBase.field_76780_h);
        TROPICAL.addLandBiome(15, BiomeGenBase.field_76782_w);
        MEDITERANEAN.addLandBiome(5, BiomeGenBase.field_76772_c);
        SAVANNA.addLandBiome(20, BiomeGenBase.field_150588_X);
        HOT_DESERT.addLandBiome(30, BiomeGenBase.field_76769_d).addLandBiome(10, BiomeGenBase.field_150608_ab);
        WASTELAND.addLandBiome(1, BiomeGenBase.field_76769_d);
        values = BOPClimates.values();
        climateMapping = new BOPClimates[]{TUNDRA, TUNDRA, TUNDRA, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, BOREAL, BOREAL, BOREAL, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, COLD_SWAMP, COLD_SWAMP, COLD_SWAMP, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, BOREAL, COLD_SWAMP, COLD_SWAMP, COLD_SWAMP, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, COLD_SWAMP, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, DRY_TEMPERATE, SAVANNA, SAVANNA, HOT_SWAMP, HOT_SWAMP, HOT_SWAMP, WET_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, HOT_SWAMP, HOT_SWAMP, WET_TEMPERATE, WARM_TEMPERATE, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND, TROPICAL, TROPICAL, TROPICAL, HOT_SWAMP, HOT_SWAMP, MEDITERANEAN, MEDITERANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND, WASTELAND};
    }

    public static class WeightedBiomeEntry {
        public final int weight;
        public final BiomeGenBase biome;

        public WeightedBiomeEntry(int weight, BiomeGenBase biome) {
            this.weight = weight;
            this.biome = biome;
        }
    }
}

